/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nfmH
 */

// forked from mex's 【AS100本ノック】2回目：たま
/** 
 * AS100本ノック
 * 2回目のお題は「たま」
 * あなたなりの「たま」を表現してください。
 * --
 * たま...キュウ...globe...
 * こうですか？わかりません。。。
 */
package
{
	import com.flashdynamix.utils.SWFProfiler;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Point;
	import flash.utils.Timer;
	import org.si.sion.*;
	import org.si.sion.events.*;
	import org.si.sion.utils.SiONPresetVoice;
	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
	public class Globe extends Sprite
	{
		private static const STAGE_WIDTH:uint = 465;
		private static const STAGE_HEIGHT:uint = 465;
		private static const STAGE_COLOR:uint = 0x000000;
		private static const MOUSE_POWER:uint = 30;
		private static const MOUSE_POWER_NORMAL:uint = 1;
		private static const MOUSE_POWER_ACTIVE:uint = 8;
		private var _driver:SiONDriver;
		private var _voice:SiONPresetVoice;
		private var _playData:SiONData;
		private var _waitData:SiONData;
		private var _waitFlag:Boolean;
		private var _frameCount:uint;
		private var _frameCountMax:uint;
		private var _flickr:FlickrManager;
		private var _particle:Vector.<Particle>;
		private var _pmove:Boolean;
		private var _bmd:BitmapData;
		private var _preMousePoint:Point;
		private var _ssprites:Vector.<SoundSprite>;
		private var _mousePower:uint = MOUSE_POWER_NORMAL;
		private var _searchQuery:String = "globe";
		public function Globe()
		{
			_driver = new SiONDriver();
			_voice = new SiONPresetVoice();
			_frameCount = 0;
			_frameCountMax = 4;
			_pmove = false;
			_waitFlag = false;
			_preMousePoint = new Point(mouseX, mouseY);
			_bmd = new BitmapData(STAGE_WIDTH, STAGE_HEIGHT, false, STAGE_COLOR);
			addChild(new Bitmap(_bmd));
			_ssprites = Vector.<SoundSprite>([
				addChild(new SoundSprite(STAGE_WIDTH*0.25, STAGE_WIDTH*0.9)),
				addChild(new SoundSprite(STAGE_WIDTH*0.5,  STAGE_WIDTH*0.9)),
				addChild(new SoundSprite(STAGE_WIDTH*0.75, STAGE_WIDTH*0.9))
			]);
			init();
			SWFProfiler.init(this);
			Wonderfl.capture_delay(15);
		}
		private function init():void
		{
			_flickr = new FlickrManager(_searchQuery);
			_playData = _driver.compile("%t t100 l4 %6@0 v20 er er er v22 o6e2");
			_playData.setVoice(0, _voice["midi.chrom5"]);
			_waitData = _driver.compile("%t t100 l4 %6@0 v14 eeeer16");
			_waitData.setVoice(0, _voice["midi.drum24"]);
			_driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME, onFrameHandler);
			_driver.addEventListener(SiONTrackEvent.NOTE_OFF_FRAME, offFrameHandler);
			_driver.addEventListener(SiONEvent.FINISH_SEQUENCE, finishSequenceHandler);
			_driver.play(_waitData);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		private function mouseDownHandler(event:MouseEvent):void
		{
			_mousePower = MOUSE_POWER_ACTIVE;
		}
		private function mouseUpHandler(event:MouseEvent):void
		{
			_mousePower = MOUSE_POWER_NORMAL;
		}
		private function onFrameHandler(event:SiONTrackEvent):void
		{
			_frameCount = _frameCount % _frameCountMax;
			if(_driver.data === _playData)
			{
				switch(_frameCount)
				{
					case 0:
						_ssprites[0].action();
						break;
					case 1:
						_ssprites[1].action();
						break;
					case 2:
						_ssprites[2].action();
						break;
					case 3:
						_ssprites[0].action();
						_ssprites[1].action();
						_ssprites[2].action();
						break;
					default:
						break;
				}
			}
			else
			{
				_ssprites[0].action(0.8, 0.3);
				_ssprites[1].action(0.8, 0.3);
				_ssprites[2].action(0.8, 0.3);
			}
		}
		private function offFrameHandler(event:SiONTrackEvent):void
		{
			if(_driver.data === _playData)
			{
				switch(_frameCount)
				{
					case 2:
						_pmove = true;
						break;
					case 3:
						_pmove = false;
						_flickr.nextLoad();
						break;
					default:
						break;
				}
				_frameCount++;
			}
		}
		private function finishSequenceHandler(event:SiONEvent):void
		{
			_driver.stop();
			_driver.addEventListener(Event.ENTER_FRAME, function(event:Event):void
			{
				if(!_driver.isPlaying)
				{
					if(_flickr.isLoaded && _waitFlag)
					{
						var p:Particle, len:uint;
						var tweens:Array = [];
						var colors:Vector.<uint> = _flickr.colors;
						var fw:uint = _flickr.width;
						var fh:uint = _flickr.height;
						var mw:uint = STAGE_WIDTH/2 - fw/2;
						var mh:uint = STAGE_HEIGHT/2 - fh/2;
						_particle = _particle || new Vector.<Particle>;
						len = _particle.length;
						for(var i:uint=0,imax:uint=colors.length; i<imax; i++)
						{
							if(i<len)
							{
								_particle[i].bx = mw+(i%fw);
								_particle[i].by = mh+(uint(i/fw));
								_particle[i].tcolor = colors[i];
								_particle[i].setColorKey();
							}
							else
							{
								p = new Particle(mw+(i%fw), mh+(uint(i/fw)), colors[i]);
								p.x = Math.random() * STAGE_WIDTH;
								p.y = Math.random() * STAGE_HEIGHT;
								_particle.push(p);
							}
						}
						if(_particle.length > colors.length)
							_particle.splice(colors.length, _particle.length - colors.length);
						_driver.play(_playData);
						_waitFlag = false;

					}
					else
					{
						_driver.play(_waitData);
						_waitFlag = true;
					}
					event.target.removeEventListener(event.type, arguments.callee);
				}
			});
		}
		private function enterFrameHandler(event:Event):void
		{
			var p:Particle;
			var dis:Number = 0;
			var mx:Number = mouseX;
			var my:Number = mouseY;
			var px:Number = (mx - _preMousePoint.x);
			var py:Number = (my - _preMousePoint.y);
			var dx:Number, dy:Number, d:Number;
			_preMousePoint.x = mx;
			_preMousePoint.y = my;
			_bmd.lock();
			_bmd.fillRect(_bmd.rect, STAGE_COLOR);
			for each(p in _particle)
			{
				if(_pmove)
				{
					p.x = movTarget(p.bx, p.x, 0.6);
					p.y = movTarget(p.by, p.y, 0.6);
				}
				else
				{
					dx = p.x - mx;
					dy = p.y - my;
					d = Math.sqrt(dx * dx + dy * dy) / _mousePower;
					p.tx += p.ax;
					p.ty += p.ay;
					p.x += p.tx + (dx + px) / d;
					p.y += p.ty + (dy + py) / d;
					p.tx *= .94;
					p.ty *= .94;
				}
				p.color = nextColor(p.tcolor, p.color, 0.4);
				_bmd.setPixel(p.x, p.y, p.color);
			}
			_bmd.unlock();
		}
		private function nextColor(tc:uint, fc:uint, s:Number=0.6):uint
		{
			if(tc != fc)
			{
				var r:uint = fc>>16 & 0xff;
				var g:uint = fc>>8 & 0xff;
				var b:uint = fc & 0xff;
				var tr:uint = tc>>16 & 0xff;
				var tg:uint = tc>>8 & 0xff;
				var tb:uint = tc & 0xff;
				r = movTarget(tr, r, s);
				g = movTarget(tg, g, s);
				b = movTarget(tb, b, s);
				return fc & 0xFF000000 | r<<16 | g<<8 | b;
			}
			return fc;
		}
		private function movTarget(tv:Number, fv:Number, s:Number):Number
		{
			return Math.abs(tv - fv) < 1 ? tv : fv + (tv - fv) * s;
		}
	}
}
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.events.Event;
import com.adobe.serialization.json.JSON;
import flash.system.LoaderContext;
import flash.display.Loader;
import flash.display.BitmapData;
import flash.display.Bitmap;
import mx.flash.UIMovieClip;
import flash.display.Sprite;
import org.libspark.betweenas3.tweens.ITween;
class FlickrManager
{
	private static const REQUEST_URL:String="http://pipes.yahooapis.com/pipes/pipe.run?_id=56f56896828db5691b7af16adc23f753&_render=json&query=";
	private static const WIDTH_LIMIT:uint = 180;
	private var _keyword:String;
	private var _urlLoader:URLLoader;
	private var _imgLoader:Loader;
	private var _pointa:uint;
	private var _width:uint;
	private var _height:uint;
	private var _loaded:Boolean;
	private var _imageList:Vector.<String>;
	private var _colorList:Vector.<uint>;
	private var _customImages:Vector.<String> = Vector.<String>([
		"http://farm4.static.flickr.com/3504/3982138785_52ce71b991.jpg",//球体っぽいもの
		"http://farm4.static.flickr.com/3418/3982138957_3d3f2c06fe.jpg",//漢字の「球」
		"http://farm4.static.flickr.com/3414/3343773753_e2913e5313_m.jpg",//のり「たま」
		"http://farm3.static.flickr.com/2437/3982901516_7c70a60631.jpg",//Oバ「Ｑ」
		"http://farm4.static.flickr.com/3094/2867491445_74c6fb730f_m.jpg"//名前が「タマ」っぽい猫
	]);
	public function FlickrManager(keyword:String)
	{
		_keyword = keyword;
		_pointa = 0;
		_width = 0;
		_height = 0;
		_loaded = false;
		_imageList = new Vector.<String>;
		init();
	}
	private function init():void
	{
		var request:URLRequest = new URLRequest(REQUEST_URL+_keyword+"&time="+(new Date).time);
		_urlLoader = new URLLoader();
		_urlLoader.addEventListener(Event.COMPLETE, completeHandler);
		try
		{
			_urlLoader.load(request);
		} catch (error:Error) {
			trace("load data failed.");
		}
	}
	public function nextLoad():void
	{
		_loaded = false;
		var request:URLRequest = new URLRequest(_imageList[_pointa]);
		var context:LoaderContext = new LoaderContext(true);
		_imgLoader = new Loader();
		_imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
		_pointa = (++_pointa) % _imageList.length;
		try
		{
			_imgLoader.load(request, context);
		} catch (error:Error) {
			trace("image load failed.");
			nextLoad();
		}
	}
	private function completeHandler(event:Event):void
	{
		if(event.target is URLLoader)
		{
			try
			{
				var jsonArr:Array = Object(JSON.decode(_urlLoader.data)).value.items;
				_imageList = _imageList.concat(_customImages);
				
				for each(var item:Object in jsonArr)
				{
					_imageList.push(item['y:flickr'].img);
				}
				nextLoad();
			} catch (error:Error) {
				trace("data parse error.");
			}
		}
		else
		{
			if(_imgLoader.width > WIDTH_LIMIT)
			{
				_imgLoader.height *= WIDTH_LIMIT / _imgLoader.width;
				_imgLoader.width = WIDTH_LIMIT;
			}
			var bmd:BitmapData = new BitmapData(_imgLoader.width, _imgLoader.height, false, 0x00FFFFFF);
			bmd.draw(_imgLoader);
			_colorList = bmd.getVector(bmd.rect);
			_width = bmd.width;
			_height = bmd.height;
			bmd.dispose();
			_loaded = true;
		}
	}
	public function get colors():Vector.<uint>
	{
		return _colorList;
	}
	public function get isLoaded():Boolean
	{
		return _loaded;
	}
	public function get width():uint
	{
		return _width;
	}
	public function get height():uint
	{
		return _height;
	}
}
class Particle
{
	public var x:Number;
	public var y:Number;
	public var tx:Number;
	public var ty:Number;
	public var ax:Number;
	public var ay:Number;
	public var bx:Number;
	public var by:Number;
	public var color:uint;
	public var tcolor:uint;
	public function Particle(x:Number, y:Number, color:uint)
	{
		this.tx = this.ax = 0;
		this.ty = this.ay = 0;
		this.x = this.bx = x;
		this.y = this.by = y;
		this.color = this.tcolor = color;
		setColorKey();
	}
	public function setColorKey():void
	{
		this.ax = ((tcolor>>8 & 0xff) - 128) * Math.random() * 0.003;
		this.ay = ((tcolor & 0xff) - 128) * Math.random() * 0.003;
	}
}
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.events.*;
import org.libspark.betweenas3.tweens.ITween;
class SoundSprite extends Sprite
{
	private static const NORMAL_SIZE:uint = 10;
	private var _t:ITween;
	public function SoundSprite(x:uint, y:uint)
	{
		graphics.clear();
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(0, 0, NORMAL_SIZE);
		graphics.endFill();
		this.x = x;
		this.y = y;
	}
	public function action(scale:Number=1.6, time:Number=0.5):void
	{
		if(_t) _t.stop();
		_t = BetweenAS3.serial(
			BetweenAS3.tween(
				this,
				{scaleX: scale, scaleY: scale},
				{scaleX: 1, scaleY: 1},
				time * 0.3,
				Expo.easeOut
			),
			BetweenAS3.tween(
				this,
				{scaleX: 1, scaleY: 1},
				null,
				time * 0.7,
				Expo.easeIn
			)
		);
		_t.play();
	}
}
