/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nfd7
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
[SWF(frameRate="30",width="465",height="465")]
	/**
	 * ...
	 * @author tenasaku
	 * based on コード01 from "wonderfl Book" section 1-3 (page 53)
	 */
	public class Main extends Sprite 
	{
		private var _c1:Circle;
		private var _c2:Circle;
		private var _c3:Circle;
		public function Main():void 
		{
			_c1 = new Circle(48,0x00FF00);
			addChild(_c1);
			_c2 = new Circle(50,0xFF0000);
			addChild(_c2);
			_c3 = new Circle(32,0x0000FF);
			addChild(_c3);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			_c1.move();
			_c2.move();
			_c3.move();
		}
		
	}
	
}

import flash.display.Sprite;

class Circle extends Sprite {
	private const windowSize_x:uint = 465;
	private const windowSize_y:uint = 465;
	private var vx:Number;
	private var vy:Number;
	public var radius:Number; // radius must be smaller than min(windowSize_x,windowSize_y) / 2
	private var dalpha:Number = 1;
	private var ralpha:Number;
	// constructor
	public function Circle(_radius:Number, _fillColor:uint = 0x000000) {
		graphics.beginFill(_fillColor);
		graphics.drawCircle(0, 0, _radius);
		graphics.endFill();
		alpha = 0.6;
		x = windowSize_x / 2;
		y = windowSize_y / 2;
		vx = Math.random()*10-5;
		vy = Math.random()*10-5;
		radius = _radius;
		ralpha = Math.random() / 50;
	}
	// to move Sprite
	public function move():void {
		x += vx;
		y += vy;
		if (x + radius >= windowSize_x) {
			x = windowSize_x - 1 - radius;
			vx = -Math.abs(vx);
		} else {
			if ( x - radius < 0 ) {
				x = radius;
				vx = Math.abs(vx);
			}
		}
		if (y + radius >= windowSize_y) {
			y = windowSize_y - 1 - radius;
			vy = -Math.abs(vy);
		} else {
			if ( y - radius < 0 ) {
				y = radius;
				vy = Math.abs(vy);
			}
		}
		alpha += dalpha * ralpha;
		if ( alpha >= 1.0 ) {
			alpha = 1.0;
			dalpha = -1;
		}
		if ( alpha <= 0.0 ) {
			alpha = 0.0;
			dalpha = 1;
		}
	}
}

