/**
 * Copyright widged ( http://wonderfl.net/user/widged )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/nefA
 */

/**
 * 
 * Adapted from Levitated.net
 * http://www.levitated.net/daily/levInvaderFractal.html
 * 
 * Changes: 
 * - Ported to Actionscript 3.
 * - Click on sprite to draw a new pattern
 * 
 * Orignal notice:
 * This program is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU General Public License as published by the Free Software Foundation.
 * 
 * This program is provided "as is".  No claims are made either explicit or implied
 * reguarding worth, compatibility, or computational merit.  Please feel free to distribute, 
 * modify, tweak, integrate, indoctorinate, or obliterate within good taste and with reasonable 
 * respect to the original author.  
 * 
 * Copyright (C) 2003 Jared Tarbell
 * Albuquerque, New Mexico
 */

package
{
    import flash.display.Sprite;
    
    public class InvaderTest extends Sprite
    {
        public function InvaderTest()
        {
            super();
            var invader:Invader = new Invader();
            invader.x = 30;
            invader.y = 30;
            addChild(invader);
        }
    }
}
 
 import flash.display.Sprite;
 import flash.events.MouseEvent;
   
 class Invader extends Sprite
    {
        private const SEED:int = 32768;
        private var rows:int = 5;
        private var cols:int = 3;
        private var sprite:Sprite;
        
        public function Invader()
        {
            super();
            addEventListener(MouseEvent.CLICK, onClick);
            var pattern:Array = getPattern();
            build(pattern);
        }
        
        
        private function onClick(event:MouseEvent):void
        {
            removeChild(sprite);
            var pattern:Array = getPattern();
            build(pattern);
        }

        private function build(pattern:Array):void 
        {
            //trace("genvader building: "+s);
            var numlit:int = 0;
            sprite = new Sprite();

            for (var x:int=0;x<cols;x++) 
            {
                for (var y:int=0;y<rows;y++) 
                {
                    var i:int=y*cols+x;
                    var nombre:String, init:Object;
                    if (isOn(pattern,i)) 
                    {
                        numlit++;
                        // trace("b"+String(x)+"-"+String(y));
                        init = {x:cols+x, y:y};
                        var boxL:PixelBox = new PixelBox(init);
                        sprite.addChild(boxL);
                        // mirror last two columns
                        if (x>0) {
                            // trace("b-"+String(x)+"-"+String(y));
                            init={x:cols-x, y:y};
                            var boxR:PixelBox = new PixelBox(init);
                            sprite.addChild(boxR);
                        }
                    }
                }
                addChild(sprite);
            }
            //    trace("build genvader: "+seedbits+"   numlit: "+numlit);
        }

        private function getPattern():Array 
        {
            var arr:Array = [];
            var iNumber:int = Math.round(Math.random() * SEED) ;

            while (iNumber>0) 
            {
                arr.unshift(iNumber%2 ? 1 : 0); 
                iNumber = Math.floor(iNumber/2);
            }
            // left pad with zeros
            while (arr.length<rows*cols) {
                arr.unshift(0);
            }
            
            return arr;
        }

        private function isOn(pattern:Array,i:int):Boolean {
            return pattern[i] == 1;
        }
    
    }


class PixelBox extends Sprite
    {
        private var DEFAULT_DIM:int               = 60;
        private var DEFAULT_BORDER_COLOR:uint     = 0x0000CC;
        private var DEFAULT_BACKGROUND_COLOR:uint = 0x0000FF;
        
        public function PixelBox(settings:Object = null)
        {
            super();
            var options:Object = parseSettings(settings, ["x","y", "dim", "borderColor", "backgroundColor"]);
            this.graphics.lineStyle(3,options.borderColor);
            this.graphics.beginFill(options.backgroundColor);
            this.graphics.drawRect(0,0,options.dim,options.dim);
            this.graphics.endFill();
            this.x = options.x * options.dim;
            this.y = options.y * options.dim;
        }
        
        private function parseSettings(settings:Object, params:Array):Object
        {
            var defaults:Object = {x: 0, y: 0, dim: DEFAULT_DIM, borderColor: DEFAULT_BORDER_COLOR, backgroundColor: DEFAULT_BACKGROUND_COLOR};
            if(!settings) return defaults;  
            for each (var p:String in params)
            {
                if(!settings.hasOwnProperty(p)) { settings[p] = defaults[p]; }      
            }
            return settings;
        }    
        
       
}