/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/neBw
 */

package {
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    import com.bit101.components.*;
    
    public class CirclesAndCircles extends Sprite {
        
        public static const COLOR: uint = 0x000000;
        public static const DISTANCE: Number = 2;
        public static const DISTANCE_INCREASE: Number = 0;
        public static const RING_SIZE: Number = 2;
        public static const RING_SIZE_INCREASE: Number = 0;
        public static const RINGS: uint = 80;
        
        private var _ringSize: Slider;
        private var _ringSizeIncrease: Slider;
        private var _distance: Slider;
        private var _distanceIncrease: Slider;
        private var _rings: Slider;
        
        private var _x: Number;
        private var _y: Number;
        
        public function CirclesAndCircles() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;            
            
            
            addChild( _ringSize = new Slider(  ) );
            _ringSize.value = RING_SIZE;
            _ringSize.maximum = 20;
            _ringSize.width = stage.stageWidth;
            _ringSize.addEventListener( Event.CHANGE, drawCircles );
            
            addChild( _ringSizeIncrease = new Slider() );
            _ringSizeIncrease.value = RING_SIZE_INCREASE;
            _ringSizeIncrease.y = 15;
            _ringSizeIncrease.minimum = -2;
            _ringSizeIncrease.maximum = 2;
            _ringSizeIncrease.width = stage.stageWidth;
            _ringSizeIncrease.addEventListener( Event.CHANGE, drawCircles );
            
            addChild( _distance = new Slider() );
            _distance.value = DISTANCE;
            _distance.y = 30;
            _distance.maximum = 20;
            _distance.width = stage.stageWidth;
            _distance.addEventListener( Event.CHANGE, drawCircles );
            
            addChild( _distanceIncrease = new Slider() );
            _distanceIncrease.y = 45;
            _distanceIncrease.minimum = -2;
            _distanceIncrease.maximum = 2;
            _distanceIncrease.value = DISTANCE_INCREASE;
            _distanceIncrease.width = stage.stageWidth;
            _distanceIncrease.addEventListener( Event.CHANGE, drawCircles );
            
            addChild( _rings = new Slider() );
            _rings.y = 60;
            _rings.minimum = 10;
            _rings.maximum = 100;
            _rings.value = RINGS;
            _rings.width = stage.stageWidth;
            _rings.addEventListener( Event.CHANGE, drawCircles );
            
            _x = stage.stageWidth/2;
            _y = stage.stageHeight/2;
            drawCircles();
            
            stage.addEventListener( MouseEvent.CLICK, changeCenter );
        }
        
        public function changeCenter( e: MouseEvent ): void {
            _x = int(e.localX)+.5;
            _y = int(e.localY)+.5;
            drawCircles();
        }

        
        public function drawCircles( e: Event = null ): void {
            graphics.clear();
            graphics.beginFill( COLOR );
            var ringSize: Number = _ringSize.value;
            var distance: Number = _distance.value;
            const rings: int = _rings.value;
            for( var i: int = 0, radius: Number = 3; i < rings; i++ ) {
                graphics.drawCircle(_x, _y, radius);
                graphics.drawCircle(_x, _y, radius+ringSize);
                radius += (distance + ringSize);
                distance += _distanceIncrease.value;
                ringSize += _ringSizeIncrease.value;
            }
            graphics.endFill();
        }

    }
}

var trace:Function = Wonderfl.log;