/**
 * Copyright evolverine ( http://wonderfl.net/user/evolverine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ndsP
 */

// forked from feeyar's flash on 2011-8-19
package 
{
    import flash.text.TextFormatAlign;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    [SWF(width="320", height="480")]
    public class Main extends Sprite
    {
        private const MAX_STEP:int = 25;
        private const COL:int = 14;
        private const ROW:int = 14;
        private var gridList:Array;
        private var colorList:Array = [0xFF6600,0x669900,0xFF99CC,0x0099FF,0xFFFF00,0xdd99cc];
        private var currentColor:uint;
        
        private var gridContainer:Sprite;
        private var stepLabel:TextField;
        private var currentStep:int;
        
        private var overTip:Sprite;
        
        public function Main() {
            createButtons();
            createCountLabel();
            createGrid();
        }
        private function createTip(str:String):void {
            removeTip();
            overTip = new Sprite();
            overTip.graphics.beginFill(0x000000, 0.2);
            overTip.graphics.drawRect(0, 0, 465, 465);
            overTip.graphics.beginFill(0x66dd00);
            overTip.graphics.drawRoundRect(20, 200, 200, 100, 10);
            overTip.graphics.endFill();
            var tiptf:TextField = new TextField();
            tiptf.width = 200;
            tiptf.height = 100;
            tiptf.selectable = false;
            tiptf.wordWrap = true;
            var tf:TextFormat = new TextFormat();
            tf.size = 15;
            tf.bold = true;
            tf.align = TextFormatAlign.CENTER;
            tiptf.defaultTextFormat = tf;
            tiptf.text = str;
            tiptf.x = 20
            tiptf.y = 200;
            overTip.addChild(tiptf);
            overTip.addEventListener(MouseEvent.CLICK, tip_clickHandler);
            addChild(overTip);
        }
        private function removeTip():void {
            if (overTip) {
                if (this.contains(overTip)) this.removeChild(overTip);
                overTip.removeEventListener(MouseEvent.CLICK, tip_clickHandler);
                overTip = null;
            }
        }
        private function tip_clickHandler(event:MouseEvent):void {
            removeTip();
            currentStep = 0;
            updateLabel();
            createGrid();
        }
        private function createButtons() : void {
            
            var b0:Grid = new Grid(colorList[0]);
            var b1:Grid = new Grid(colorList[1]);
            var b2:Grid = new Grid(colorList[2]);
            var b3:Grid = new Grid(colorList[3]);
            var b4:Grid = new Grid(colorList[4]);
            var b5:Grid = new Grid(colorList[5]);
            b0.buttonMode = b1.buttonMode = b2.buttonMode = b3.buttonMode = b4.buttonMode = b5.buttonMode = true;
            b0.y = b1.y = b2.y = b3.y = b4.y = b5.y = 10;
            b0.x = 10;
            b1.x = 50;
            b2.x = 90;
            b3.x = 130;
            b4.x = 170;
            b5.x = 210;
            
            b0.addEventListener(MouseEvent.CLICK, b0_clickHandler);
            b1.addEventListener(MouseEvent.CLICK, b1_clickHandler);
            b2.addEventListener(MouseEvent.CLICK, b2_clickHandler);
            b3.addEventListener(MouseEvent.CLICK, b3_clickHandler);
            b4.addEventListener(MouseEvent.CLICK, b4_clickHandler);
            b5.addEventListener(MouseEvent.CLICK, b5_clickHandler);
            
            addChild(b0);
            addChild(b1);
            addChild(b2);
            addChild(b3);
            addChild(b4);
            addChild(b5);
        }
        private function b3_clickHandler(event : MouseEvent) : void {
            clickGrid(3);
        }
        private function b2_clickHandler(event : MouseEvent) : void {
            clickGrid(2);
        }
        private function b1_clickHandler(event : MouseEvent) : void {
            clickGrid(1);
        }
        private function b0_clickHandler(event : MouseEvent) : void {
            clickGrid(0);
        }
        private function b4_clickHandler(event : MouseEvent) : void {
            clickGrid(4);
        }
        private function b5_clickHandler(event : MouseEvent) : void {
            clickGrid(5);
        }
        private function createCountLabel() : void {
            stepLabel = new TextField();
            stepLabel.width = 100;
            stepLabel.height = 35;
            stepLabel.defaultTextFormat = new TextFormat("Arial", 13, 0x000000);
            stepLabel.selectable = false;
            stepLabel.y = 40;
            stepLabel.x = 10;
            updateLabel();
            addChild(stepLabel);
        }
        private function createGrid() : void {
            if (gridContainer) {
                while (gridContainer.numChildren > 0) {
                    gridContainer.removeChildAt(0);
                }
            } else {
                gridContainer = new Sprite();
                gridContainer.x = 10;
                gridContainer.y = 100;
                addChild(gridContainer);
            }
            gridList = [];
            for (var i:int = 0;i<ROW;i++) {
                var temp:Array = [];
                for (var j:int = 0;j<COL;j++) {
                    var grid:Grid = new Grid(colorList[Math.random()*6 >> 0]);
                    if (i==0&&j==0) {
                        grid.flooded = true;
                        currentColor = grid.color;
                    }
                    grid.col = j;
                    grid.row = i;
                    temp.push(grid);
                    gridContainer.addChild(grid);
                }
                gridList.push(temp);
            }
            flood();
        }
        private function clickGrid(colorIndex:int):void {
            currentStep++;
            currentColor = colorList[colorIndex];
            flood();
            updateLabel();
            check();
        }
        private function updateLabel():void {
            stepLabel.text = "" + currentStep + "/" + MAX_STEP;
        }
        private function check():void {
            var overFlag:Boolean = true;
            for each(var list:Array in gridList) {
                for each(var grid:Grid in list){
                    if (!grid.flooded) overFlag = false; 
                }
            }
            if (overFlag) {
                if (currentStep >= MAX_STEP) {
                    createTip("LOSER,YOU FAILED!!!!!!!!!");
                } else {
                    createTip("Success!!!!!");
                }
            }
            if (currentStep > MAX_STEP) {
                createTip("LOSER,YOU FAILED!!!!!!!!!");
            }
        }
        private function flood():void {
            for (var i:int=0; i<ROW; i++) {
                for (var j:int=0; j<COL; j++) {
                    var grid:Grid = gridList[i][j];
                    if (grid.flooded) {
                        grid.color = currentColor;
                        if (j<COL-1) {
                            var rightGrid:Grid = gridList[i][j+1];
                            if (rightGrid.color == currentColor && !rightGrid.flooded) {
                                rightGrid.flooded = true;
                            }
                        }
                        if (j>0) {
                            var leftGrid:Grid = gridList[i][j-1];
                            if (leftGrid.color == currentColor && !leftGrid.flooded) {
                                leftGrid.flooded = true;
                            }
                        }
                        if (i<ROW-1) {
                            var downGrid:Grid = gridList[i+1][j];
                            if (downGrid.color == currentColor && !downGrid.flooded) {
                                downGrid.flooded = true;
                            }
                        }
                        if (i>0) {
                            var upGrid:Grid = gridList[i-1][j];
                            if (upGrid.color == currentColor && !upGrid.flooded) {
                                upGrid.flooded = true;
                            }
                        }
                    }
                }
            }
        }
    }
}
import flash.display.Sprite;
class Grid extends Sprite {
        private const WIDTH:Number = 20;
        private var _col:int;
        private var _row:int;
        private var _color:uint;
        public var flooded:Boolean = false;
        
        public function Grid(value:uint) {
            this._color = value;
            draw(color);
        }
        public function set col(value:uint):void {
            _col = value;
            this.x = value * WIDTH;
        }
        public function get col():uint {
            return this._col;
        }
        public function set row(value:uint):void {
            _row = value;
            this.y = value * WIDTH;
        }
        public function get row():uint {
            return _col;
        }
        public function set color(value:uint):void {
            this._color = value;
            draw(this._color); 
        }
        public function get color():uint {
            return this._color;
        }
        private function draw(color:uint):void {
            this._color = color;
            this.graphics.clear();
            this.graphics.beginFill(color);
            this.graphics.drawRect(0, 0, WIDTH, WIDTH);
            this.graphics.endFill();
        }
    }