/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ndaM
 */

// forked from matacat's forked from: forked from: 点描風
// forked from uwi's forked from: 点描風
// forked from moringo2's 点描風
// 軽量・高速化。
// うまく合成するBlendModeがなかったのでアルファはなくして上書き。
// -> Shape インスタンスを用意し、そこに点描してから canvas に draw するように変更 - matacat

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.Timer;
    
    [SWF(width=465,height=465,backgroundColor=0x000000)]//0xffffff
    
    public class IMTest extends Sprite
    {
        private const imgPaths:Array = [
            "http://assets.wonderfl.net/images/related_images/0/0e/0e8c/0e8cb3fa40a65539d2adf599ab55a156a587e012",
            "http://assets.wonderfl.net/images/related_images/7/77/7763/77634ff04c7198c7422b2eab9a6a80825aa6b48b",
            "http://farm4.static.flickr.com/3078/2328337281_ee32463b4e.jpg" ];
        private var loader:Loader;
        
        private var bCanvas:Bitmap = new Bitmap();
        private var vCanvas:Shape  = new Shape();
        private var bmd:BitmapData;
        
        private var t:Timer        = new Timer(1000, 1);
        private var rect:Rectangle = new Rectangle();
        private var mx:Matrix      = new Matrix();
        private var id:int;
        private var cnt:int;
        private var cntMax:int;
        private var a:Number;
        private var wz:int;
        private var hi:int;
        
        
        public function IMTest()
        {
            addChild(bCanvas);
            id = 0;
            cntMax = 320;
            
            t.addEventListener(TimerEvent.TIMER_COMPLETE, function(e:TimerEvent):void
            {
                a = 1;
                addEventListener(Event.ENTER_FRAME, fadeOut);
            });
            
            init();
        }
        
        private function init():void
        {
            loader = new Loader();
            loader.load(new URLRequest(imgPaths[id]), new LoaderContext(true));
            
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, comp);
        }
        
        private function comp(e:Event):void
        {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, comp);
            
            bmd = Bitmap(loader.content).bitmapData;
            wz = bmd.width;
            hi = bmd.height;
            var thirdWz:int = wz / 3;
            var thirdHi:int = hi / 3;
            
            bCanvas.bitmapData = new BitmapData(wz, hi, false, 0xFFFFFF);
            vCanvas.graphics.clear();
            var color:Array = [];
            
            rect.x = 0;
            rect.y = 0;
            rect.width = wz;
            rect.height = thirdHi;
            for (var i:int = 0; i < 3; i++) {
                color[i] = avgColor();
                rect.y += thirdHi;
            }
            mx.createGradientBox(wz, hi, Math.PI / 2);
            vCanvas.graphics.beginGradientFill("linear", color, [0.5, 0.5, 0.5], [0, 127, 255], mx);
            vCanvas.graphics.drawRect(0, 0, wz, hi);
            
            rect.x = 0;
            rect.y = 0;
            rect.width = thirdWz;
            rect.height = hi;
            for (i = 0; i < 3; i++) {
                color[i] = avgColor();
                rect.x += thirdWz;
            }
            mx.createGradientBox(wz, hi);
            vCanvas.graphics.beginGradientFill("linear", color, [0.5, 0.5, 0.5], [0, 127, 255], mx);
            vCanvas.graphics.drawRect(0, 0, wz, hi);
            
            bCanvas.bitmapData.draw(vCanvas);
            
            cnt = 0;
            addEventListener(Event.ENTER_FRAME, drawCircle);
            
            a = 0;
            addEventListener(Event.ENTER_FRAME, fadeIn);
        }
        
        private function drawCircle(e:Event):void
        {
            var nm:int    =  10 + 140 * cnt / cntMax;
            var al:Number = 0.2 + 0.6 * cnt / cntMax;
            var rd:Number =   2 +   8 * (1 - cnt / cntMax);
            vCanvas.graphics.clear();
            
            for (var j:int = 0; j < nm; j++) {
                var randX:int = Math.random() * wz;
                var randY:int = Math.random() * hi;
                rect.x = randX - rd >> 0;
                rect.y = randY - rd >> 0;
                rect.width = rect.height = rd << 1;
                vCanvas.graphics.beginFill(avgColor(), al);
                vCanvas.graphics.drawCircle(randX, randY, rd);
            }
            bCanvas.bitmapData.draw(vCanvas);
            cnt++;
            
            if(cnt >= cntMax){
                removeEventListener(Event.ENTER_FRAME,drawCircle);
                t.start();
            }
        }
        
        private function avgColor():uint
        {
            var avg:uint = 0;
            var hist:Vector.<Vector.<Number>> = bmd.histogram(rect.intersection(bmd.rect));
            
            for (var i:int = 0; i < 3; i++) {
                var vec:Vector.<Number> = hist[i];
                var sum:Number = 0;
                var num:int = 0;
                
                for (var j:int = 0, l:int = vec.length; j < l; j++) {
                    sum += j * vec[j];
                    num += vec[j];
                }
                
                if (num == 0) num = 1;
                avg = avg << 8 | uint(sum / num);
            }
            
            return avg;
        }
        
        private function fadeOut(e:Event):void
        {
            a -= 0.02;
            bCanvas.alpha = a;
            if (a <= 0) {
               removeEventListener(Event.ENTER_FRAME, fadeOut);
               bCanvas.alpha = 0;
               restart();
            }
        }
        
        private function fadeIn(e:Event):void
        {
            a += 0.02;
            bCanvas.alpha = a;
            if (a >= 1) {
               removeEventListener(Event.ENTER_FRAME, fadeIn);
               bCanvas.alpha = 1;
            }
        }
        
        private function restart():void
        {
            loader = null;
            bCanvas.bitmapData.dispose();
            bmd.dispose();
            id = id < imgPaths.length - 1 ? id + 1 : 0;
            init();
        }
    }
}