/**
 * Copyright kotaro_tan ( http://wonderfl.net/user/kotaro_tan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ndYt
 */

package {
    import flash.filters.GlowFilter;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.BitmapDataChannel;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.filters.DisplacementMapFilter;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    public class BitmapDataSample extends Sprite {
        private var bmpData:BitmapData;
        private var _sp:Sprite;
        private var matrix:Matrix;
        private var colortrans:ColorTransform;
        private var bmpcolortrans:ColorTransform;
        //private var filter:BlurFilter;
        private var filter:DisplacementMapFilter;
        
        public function BitmapDataSample() {
           bmpData = new BitmapData(465, 465, false, 0x000000);
           addChild(new Bitmap(bmpData));
           _sp = newFig(0, 0, 40, 0xFFFFFF);
           matrix = new Matrix();
           colortrans = new ColorTransform();
           bmpcolortrans = new ColorTransform(0.99, 0.99, 0.999);
           //filter = new BlurFilter(2, 2, 1);
           var mapBitmap:BitmapData = new BitmapData(465, 465, false, 0x000000);
           var mapPoint:Point = mapBitmap.rect.topLeft;
           var comX:uint = BitmapDataChannel.RED;
           var comY:uint = BitmapDataChannel.GREEN;
           var scaleX:Number = 256;
           var scaleY:Number = 256;
           var r:uint = 128 + 2;
           var g:uint = 128 + 1;
           var b:uint = 128;
           var col:uint = r << 16 | g << 8 | b;
           mapBitmap.fillRect(mapBitmap.rect, col);
           filter = new DisplacementMapFilter(mapBitmap, mapPoint, comX, comY, scaleX, scaleY);
           
           addEventListener(Event.ENTER_FRAME, onEnterFrame);
           stage.addEventListener(MouseEvent.CLICK, reset);
 
        }
        
        private function onEnterFrame(e:Event):void {
            matrix.identity();
            var s:Number = Math.random() * 2;
            matrix.scale(s, s);
            matrix.rotate(Math.PI * Math.random());
            matrix.translate(mouseX, mouseY);
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
            bmpData.colorTransform(bmpData.rect, bmpcolortrans);
            bmpData.applyFilter(bmpData, bmpData.rect, bmpData.rect.topLeft, filter);
            bmpData.draw(_sp, matrix, colortrans, BlendMode.ERAS);
        }
        
        private function reset(e:MouseEvent):void {
            bmpData.fillRect(bmpData.rect, 0xFF000000);
            
        }


      

        private function newFig(cx:Number, cy:Number, size:Number, col:uint):Sprite {
            var sp:Sprite = new Sprite;
            sp.graphics.lineStyle(0, 0x000000, 0.3);
            sp.graphics.beginFill(col);
            sp.graphics.drawCircle(cx, cy, size * 0.5);
            sp.graphics.drawCircle(cx, cy, size * 0.4);
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            sp.graphics.drawRect(cx - w / 2, cy - h / 2, w, h);
            sp.filters = [new BlurFilter(2, 2, 1)];
            sp.graphics.endFill();
            return sp;
            
        }

        
        
        
    }
}