/**
 * Copyright faseer ( http://wonderfl.net/user/faseer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ndNL
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            this.addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            draw( new Point(200, 50), new Point(200, 400) );
        }
        
        private function draw( p:Point, q:Point ):void
        {
            var dy:Number = q.y - p.y;
            var dx:Number = q.x - p.x;
            
            const max:int = 20;
            var vertex:Vector.<Point> = new Vector.<Point>( max, true );
            vertex[0] = p;
            vertex[vertex.length-1]=q;
            
            var ddy:Number = dy / max;
            var ddx:Number = dx / max;
            var i:int;
            for(i=1; i < max - 1; ++i)
            {
                var tx:Number = p.x + ddx * i + Math.random() * 20 - 10;
                var ty:Number = p.y + ddy * i + Math.random() * 20 - 10;
                vertex[i] = new Point( tx, ty );
            }
            
            this.graphics.clear();
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,800,800);
            this.graphics.endFill();

            this.graphics.lineStyle(5,0x336699);
            this.graphics.moveTo(vertex[0].x, vertex[0].y);
            for(i=1; i < max; ++i)
            {
                this.graphics.lineTo(vertex[i].x ,vertex[i].y);
            }

            this.graphics.lineStyle(2,0xffffff);
            this.graphics.moveTo(vertex[0].x, vertex[0].y);
            for(i=1; i < max; ++i)
            {
                this.graphics.lineTo(vertex[i].x ,vertex[i].y);
            }

            this.graphics.lineStyle(0.5,0xffffff);
            this.graphics.moveTo(vertex[0].x ,vertex[0].y);
            for(i=1; i < max; i+=2+Math.random()*5)
            {
                this.graphics.lineTo(vertex[i].x, vertex[i].y);
            }

           

        }


    }
}