/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ndJK
 */

/*
 * 
 * Draw a Tasty Ramen !
 * 
 * You can edit and modify every piece of this code.
 * Load more pictures of GU (ingredients of ramen)
 * from flickr or draw one by yourself.
 * Make it look tasty.
 *
 */
package{
	import flash.display.Sprite;
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.net.*;
	import flash.system.*;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Point;

    [SWF(width="460", height="460", backgroundColor="0xFFFFFF", frameRate="30")]

    public class FlashTest extends Sprite{
        private var _loader        :Loader;
        private var _loaderInfo    :LoaderInfo;
        private var _loader_GU     :Loader;
        private var _loaderInfo_GU :LoaderInfo;

        private var RAMEN_URL :String   = "http://farm3.static.flickr.com/2589/3787648401_0b3d62a314_o.png";
        private var NARUTO1_URL :String = "http://farm3.static.flickr.com/2466/3787648415_1f857d46cf_o.png";
        private var NARUTO2_URL :String = "http://farm4.static.flickr.com/3560/3788456920_5101174e6c_o.png";
        private var MENMA_URL :String   = "http://farm3.static.flickr.com/2628/3788456906_91e357245f_o.png";
		
		private var bmd:BitmapData;
		private var offset:Array;
		private var KiraArr:Array;
		private var KiraSize:Array;

        public function FlashTest() {
			initBackground();
            init();
        }
        private function init():void{
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;

            _loader=new Loader();
            _loader.load(new URLRequest(RAMEN_URL));

            _loaderInfo=_loader.contentLoaderInfo;
            _loaderInfo.addEventListener(Event.COMPLETE,onLoadComplete);
        }
        private function onLoadComplete(event:Event):void{
            _loaderInfo.removeEventListener(Event.COMPLETE,onLoadComplete);
            addChild(_loader);
            load_GU();
        }
        private function load_GU():void{
            _loader_GU=new Loader();
            _loader_GU.load(new URLRequest(NARUTO1_URL));

            _loaderInfo_GU=_loader_GU.contentLoaderInfo;
            _loaderInfo_GU.addEventListener(Event.COMPLETE,onLoadComplete_GU);
        }
        private function onLoadComplete_GU(event:Event):void{
            _loaderInfo_GU.removeEventListener(Event.COMPLETE,onLoadComplete_GU);

            // position adjustment for GU
            _loader_GU.x = 160;
            _loader_GU.y = 160;
            addChild(_loader_GU);
			
			drawGradient();
			
			createKira(50);
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				offset[0].y += 10;
				bmd.perlinNoise(100, 100, 1, 20, true, true, (8|4|2|1), false, offset);
				for (var j:uint = 0; j < KiraArr.length; j++) {
					KiraArr[j].tinkle();
					KiraArr[j].alpha = alpha;
					var tmp:Number = KiraArr[j].y - KiraSize[j] / 5;
					if (tmp < -50) tmp = 510;
					KiraArr[j].y = tmp;
				}
			});
        }
		
		private function initBackground():void {
			bmd = new BitmapData(465, 465, false);
			addChild(new Bitmap(bmd));
			offset = [new Point(0,0)];
		}
		
		private function createKira(num:uint):void {
			KiraArr = new Array();
			KiraSize = new Array();
			for (var i:uint = 0; i < num; i++) {
				KiraSize.push(20 + 30 * Math.random());
				var k:Kira = new Kira(KiraSize[i] * 0.8, KiraSize[i], Math.floor(KiraSize[i] / 3));
				addChild(k);
				k.x = Math.random() * 465;
				k.y = Math.random() * 565 - 50;
				KiraArr.push(k);
			}
		}
		
		private function drawGradient():void {
			var sprite:Sprite = new Sprite();
			var matrix:Matrix=new Matrix();
			matrix.translate(230, 230);
			
			sprite.graphics.beginGradientFill(
				GradientType.RADIAL,
				[0xFFFFFF, 0xFFFFFF],
				[0, 1],
				[0, 128],
				matrix
			);
			sprite.graphics.drawRect(0, 0, 465, 465);
			addChild(sprite);
		}

    }
}


import flash.display.Sprite;
import flash.filters.BlurFilter;

class Kira  extends Sprite
{
	private var obj:Sprite
	
	public function Kira(kw:Number, kh:Number, flt:Number):void
	{
		obj = new Sprite();
		obj.alpha = Math.random();
		obj.graphics.beginFill(0xFFFFFF);
		obj.graphics.moveTo(0, -kh);
		obj.graphics.curveTo(0, 0, kw, 0);
		obj.graphics.curveTo(0, 0, 0, kh);
		obj.graphics.curveTo(0, 0, -kw, 0);
		obj.graphics.curveTo(0, 0, 0, -kh);
		obj.graphics.endFill();
		obj.filters = [ new BlurFilter(flt , flt) ];
		addChild(obj);
	}
	
	public function tinkle():void
	{
		var tmp:Number = obj.alpha -0.2;
		if (tmp < 0) tmp = 1;
		obj.alpha = tmp;
	}
	
}

