/**
 * Copyright mizgyo ( http://wonderfl.net/user/mizgyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nd0V
 */

// forked from nplusone's forked from: rain on 2009-9-19
// forked from naoki's rain on 2009-9-19
// Music is licensed under a Creative Commons Attribution 3.0 License.
// Music:Cornelius / Wataridori 2
package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;
    import caurina.transitions.properties.ColorShortcuts;
    import flash.display.*;
    import flash.display.LineScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.system.Security;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.text.TextFormat;
    import flash.text.TextField;
    
    
    [SWF(height=500, width=500, backgroundColor="#FFFFFF", frameRate=30)]
    
    FilterShortcuts.init();   //FilterShortcutsの初期化
    ColorShortcuts.init();      //ColorShortcutsの初期化
    
    public class Rain extends Sprite {

        //読み込むサウンドの定義
        private var urlReq:URLRequest = new URLRequest("http://www.nplusone.be/sound/Wataridori.mp3");
        private var snd:Sound = new Sound();
        private var sndCh:SoundChannel;
    
        //ステージサイズ
        private var SWF_WIDTH:uint = 500;
        private var SWF_HEIGHT:uint = 500;

        //
        // コンストラクタ
        //
        public function Rain() {
            //外部ドメインからデータを読み込めるようにする
            Security.loadPolicyFile("http://www.nplusone.be/crossdomain.xml"); 
            //ステージの初期化
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
            
            //フレームが読み込まれる度に雫をつくる
            this.addEventListener(Event.ENTER_FRAME, makeOneDrop);        
            
            //サウンドの再生
            snd.load(urlReq);
            sndCh = snd.play(0, 1000);
            }

        //
        // 雨の雫をひとつ描く
        //
        private function makeOneDrop(e:Event):void
        {
            // サウンドの波形解析結果を格納するための配列を用意する
            var outputByteArray:ByteArray = new ByteArray();
            // サウンド波形解析
            SoundMixer.computeSpectrum(outputByteArray, false, 0);              
            
            //色をランダムに
            var col1:uint = Math.floor(Math.random() * 0xFFFFFF);
            
            //ブラーフィルター
            var fil:BlurFilter = new BlurFilter();
             fil.blurX = 15;
             fil.blurY = 15;
             fil.quality = BitmapFilterQuality.HIGH;
                         
            //円を描く
            var drop:Sprite = new Sprite();
            drop.graphics.beginFill(col1);
            drop.graphics.drawCircle(0, 0, 1);
            drop.graphics.endFill();
            drop.filters = [fil];
            drop.x = Math.random() * SWF_WIDTH;
            drop.y = Math.random() * SWF_HEIGHT;
                        
            var n:Number = 0;
            
            for (var i:int = 0; i < 256; i++) 
            {
            //波形解析結果の戻り値を整数として格納
            n = (outputByteArray.readFloat() * 1000);
                //小さすぎる数字を無視する
                if (n>10){
                this.addChild(drop);
                }
            //波形の数字を元に雫の大きさを変化させる。ランダムな色から白に変化させる。
            Tweener.addTween(drop,{_color:0xFFFFFF,scaleX:n,scaleY:n,alpha:0,time:5,transition:"easeOutSine"});
            }
        }
    }
}
