/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ncal
 */

// forked from _wonder's 三角形を使って立方体：3Dの回転
// forked from _wonder's 三角形を使う：3Dの回転
// forked from _wonder's 3Dの回転 平面
// forked from _wonder's 3Dの回転 線だけ2
// forked from _wonder's 3Dの回転 線だけ
// forked from _wonder's 3Dの回転 + 線
// forked from _wonder's 3Dの回転
// forked from _wonder's 複数のボール跳ね返り3D
// forked from _wonder's 跳ね返り3D
// forked from _wonder's ボールを動かす3D
// forked from _wonder's 遠ざかるボール
// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    public class Triangles2 extends Sprite {
        private var points:Array;
        private var triangles:Array;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        private var offsetX:Number = 0;
        private var offsetY:Number = 0;
        
        public function Triangles2() {
            points = new Array();
            points[0] = new Point3D( -100, -100, -100 );
            points[1] = new Point3D( 100, -100, -100 );
            points[2] = new Point3D( 100, 100, -100 );
            points[3] = new Point3D( -100, 100, -100 );
            points[4] = new Point3D( -100, -100, 100 );
            points[5] = new Point3D( 100, -100, 100 );
            points[6] = new Point3D( 100, 100, 100 );
            points[7] = new Point3D( -100, 100, 100 );
            
            for( var i:uint = 0; i < points.length; i++ ){
                points[i].setVanishingPoint( vpX, vpY );
                points[i].setCenter(0, 0, 200 );
            }
            
            triangles = new Array();
            triangles[0] = new Triangle( points[0], points[1], points[2], 0x6666cc);
            triangles[1] = new Triangle( points[0], points[2], points[3], 0x6666cc);
            
            triangles[2] = new Triangle( points[0], points[5], points[1], 0x66cc66);
            triangles[3] = new Triangle( points[0], points[4], points[5], 0x66cc66);
            
            triangles[4] = new Triangle( points[4], points[6], points[5], 0xcc6666);
            triangles[5] = new Triangle( points[4], points[7], points[6], 0xcc6666);
            
            triangles[6] = new Triangle( points[3], points[2], points[6], 0xcc66cc);
            triangles[7] = new Triangle( points[3], points[6], points[7], 0xcc66cc);
            
            triangles[8] = new Triangle( points[1], points[5], points[6], 0x66cccc);
            triangles[9] = new Triangle( points[1], points[6], points[2], 0x66cccc);
            
            triangles[10] = new Triangle( points[4], points[0], points[3], 0xcccc66);
            triangles[11] = new Triangle( points[4], points[3], points[7], 0xcccc66);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function onEnterFrame(e:Event):void {
            var angleY:Number = ( mouseX - vpX ) * 0.0002;
            var angleX:Number = ( mouseY - vpY ) * 0.0002;
            for( var i:uint = 0; i < points.length; i++ ){
                var point:Point3D = points[i];
                point.rotateX( angleX );
                point.rotateY( angleY );
            }
            graphics.clear();
            for( i = 0; i < triangles.length; i++ ){
                triangles[i].draw( graphics );
            }
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if( e.keyCode == Keyboard.LEFT ){
                offsetX += -5;
            } else if( e.keyCode == Keyboard.RIGHT ){
                offsetX += 5;
            } else if( e.keyCode == Keyboard.UP ){
                offsetY += -5;
            } else if( e.keyCode == Keyboard.DOWN ){
                offsetY += 5;
            }
            for( var i:Number = 0; i < points.length; i++ ){
                points[i].setCenter( offsetX, offsetY, 200 );
            }

        }

    }
}

import flash.display.Graphics;

class Triangle {
    private var pointA:Point3D;
    private var pointB:Point3D;
    private var pointC:Point3D;
    private var color:uint;
    
    public function Triangle ( a:Point3D, b:Point3D, c:Point3D, color:uint ){
        pointA = a;
        pointB = b;
        pointC = c;
        this.color = color;
    }
    
    public function draw(g:Graphics):void {
        g.beginFill( color, 0.5 );
        g.moveTo( pointA.screenX, pointA.screenY );
        g.lineTo( pointB.screenX, pointB.screenY );
        g.lineTo( pointC.screenX, pointC.screenY );
        g.lineTo( pointA.screenX, pointA.screenY );
        g.endFill();
    }


}

class Point3D {
    public var fl:Number = 250;
    private var vpX:Number = 0;
    private var vpY:Number = 0;
    private var cX:Number = 0;
    private var cY:Number = 0;
    private var cZ:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
    public function Point3D( x:Number=0, y:Number=0, z:Number=0 ){
        this.x = x;
        this.y = y;
        this.z = z;
    }
    
    public function setVanishingPoint( vpX:Number, vpY:Number ):void {
        this.vpX = vpX;
        this.vpY = vpY;
    }
    
    public function setCenter( cX:Number, cY:Number, cZ:Number=0 ):void {
        this.cX = cX;
        this.cY = cY;
        this.cZ = cZ;
    }
    
    public function get screenX():Number {
        var scale:Number = fl / ( fl + z + cZ );
        return vpX + cX + x * scale;
    }
    
    public function get screenY():Number {
        var scale:Number = fl / ( fl + z + cZ );
        return vpY + cY + y * scale;
    }
    
    public function rotateX( angleX:Number ):void {
        var cosX:Number = Math.cos( angleX );
        var sinX:Number = Math.sin( angleX );
            
        var y1:Number = y * cosX - z * sinX;
        var z1:Number = z * cosX + y * sinX;
            
        y = y1;
        z = z1;
    }
    
    public function rotateY( angleY:Number ):void {
        var cosY:Number = Math.cos( angleY );
        var sinY:Number = Math.sin( angleY );
            
        var x1:Number = x * cosY - z * sinY;
        var z1:Number = z * cosY + x * sinY;
            
        x = x1;
        z = z1;
    }
    
    public function rotateZ( angleZ:Number ):void {
        var cosZ:Number = Math.cos( angleZ );
        var sinZ:Number = Math.sin( angleZ );
            
        var x1:Number = x * cosZ - y * sinZ;
        var y1:Number = y * cosZ + x * sinZ;
            
        x = x1;
        y = y1;
    }
}