/**
 * Copyright publicroots ( http://wonderfl.net/user/publicroots )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nc9D
 */

// forked from muta244's [実験] 変数名の長さによって処理速度が変わるのか？
package {

import flash.display.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    private var _a:String = "test";
    private var _abcdefghijklmnopqrstuvwsyzabcdefghijklmnopqrst:String = "test";
    
    public function Main():void
    {
        _setup();
        
        _measure("変数名が短い変数宣言", function ():void
        {
            var a:String;
        }, 100000);
        
        _measure("変数名が長い変数宣言", function ():void
        {
            var abcdefghijklmnopqrstuvwsyzabcdefghijklmnopqrstuvwsyzabcd:String;
        }, 100000);
        
        _measure("変数名が短いプロパティ参照", function ():void
        {
            _a;
        }, 100000);
        
        _measure("変数名が長いプロパティ参照", function ():void
        {
            _abcdefghijklmnopqrstuvwsyzabcdefghijklmnopqrst;
        }, 100000);
        
        _measure("変数名が短いプロパティのハッシュ参照", function ():void
        {
            this["_a"];
        }, 100000);
        
        _measure("変数名が長いプロパティのハッシュ参照", function ():void
        {
            this["_abcdefghijklmnopqrstuvwsyzabcdefghijklmnopqrst"];
        }, 100000);
    }
    
    private function _measure(
        title:String, func:Function, numTimes:uint, ...params):void
    {
        _time = getTimer();
        
        for (var i:int = 0; i < numTimes; i++) {
            func.apply(null, params);
        }
        
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth;
        _field.height = stage.stageHeight;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
    }
}

}