/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nafR
 */

// forked from clockmaker's [Progression4] LoadCommand系のcatchErrorの仕様について
package
{
	// Load系コマンドでは二度目以降の読み込みに対して
	// catchErrorが発生しない仕様(もしくは不具合)

	// Progressionフォーラムに投稿
	// http://forum.progression.jp/index.php?topic=315.0
	
	public class Main extends Sprite
	{
		public static const URL:String = "hoge.jpg";
		
		public function Main()
		{
			var btn:PushButton = new PushButton(this, 10, 10, "LOAD START", _onClick);
			_label = new Text(this, 10, 100, "");
		}
		
		private var _label:Text;

		private function _onClick(e:Event):void
		{
			_label.text = "NOW LOADING";
			
			_label.text += "\nResource : "
			_label.text += getResourceById(URL)
			var list:SerialList = new SerialList();
			
			// エラーハンドリング
			list.catchError = function(target:Command, err:Error):void
			{
				// 二回目以降が呼ばれない
				_label.text += "\nCATCH ERROR : \n" + target.toString() + ", \n"+ err.toString();
				target.executeComplete();
			};
			
			// 読み込み処理
			list.addCommand(
				new LoadBitmapData(new URLRequest(URL)),
				function():void
				{
					_label.text += "\n Complete"
					var res:Resource = getResourceById(URL);
					
					if(res && res.data)
					{
						_label.text += "\n Success"

						// 読み込みが正常だったときの処理	
					}
					else
					{
						_label.text += "\n Fail"
						// 読み込みが行われなかったときの処理
					}
				});
			list.execute();
			Debugger.addTarget(list);
		}
	}
	
	import com.bit101.components.PushButton;	
	import com.bit101.components.Text;		
	import flash.display.Sprite;	
	import flash.events.Event;	
	import flash.net.URLRequest;		
	import jp.progression.debug.Debugger;
	import jp.progression.commands.Command;	
	import jp.progression.commands.lists.SerialList;	
	import jp.progression.commands.net.LoadBitmapData;	
	import jp.progression.data.Resource;	
	import jp.progression.data.getResourceById;
}