/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nZww
 */

// forked from HaraMakoto's Tweenerでミサイルぽく移動
package {
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.CurveModifiers;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	[SWF(width=465, height=465, backgroundColor=0, frameRate=60)]
	public class LineVector extends Sprite
	{
		CurveModifiers.init();
		/**
		 * pararm
		 */
                private var moveObj:Sprite;
		private var trans:String = "easeOutQuint";
		
		public function LineVector()
		{
			moveObj = new Ball();
                        addChild( moveObj );
			addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
		}
		
		private function addStageHandler(e:Event):void
		{
			stage.addEventListener(MouseEvent.MOUSE_DOWN, startLine );
		}
		//クリックで目標切り替え
		private function startLine(e:MouseEvent):void
		{
                    stage.addEventListener( Event.ENTER_FRAME, drawLine );
                    stage.addEventListener( MouseEvent.MOUSE_UP, fire );
                    
                    graphics.clear();
                    graphics.lineStyle( 4, 0x660000, 0.2 );
                    graphics.moveTo( mouseX, mouseY );
                    
                    _moveCount = 0;
                    _points = [ new Point(mouseX,mouseY) ];
		}
                private var _points:Array = [];
                private var _moveCount:int = 0;
                private function drawLine(e:Event):void {
                    graphics.lineTo( mouseX, mouseY );
                    
                    if( ( _moveCount++) % 5== 0 ) {
                        _points.push( new Point( mouseX, mouseY ) );
                        graphics.beginFill( 0xFFFF00,0.2 );
                        graphics.drawCircle( mouseX, mouseY, 4 );
                        graphics.endFill();
                    }
                        
                }
                private function fire( e:Event ):void {
                    stage.removeEventListener( Event.ENTER_FRAME, drawLine );
                    var bz:Array = [];
                    for( var i:int=0, l:int=_points.length; i<l; ++i ) {
                        var p0:Point = _points[i];
                        var p1:Point = _points[i+1];
                        
                        bz[i] = { x: p0.x, y:p0.y };
                        //bz[i] = { x:(p1.x -p0.x)*0.5+p0.x, y:(p1.y -p0.y)*0.5+p0.y };
                    }
                    moveObj.x = _points[0].x;
                    moveObj.y = _points[0].y;
                    Tweener.addTween(moveObj,{x:mouseX, y:mouseY, _bezier:bz, time:3, transition:trans});
		}
	}
}
	import flash.display.Sprite;
	


class Ball extends Sprite {
	public var vx:Number = 10;
	public var vy:Number = 5;
	public function Ball ()
	{
		makeCirc();
	}
	
	private function makeCirc():void
	{
		this.graphics.beginFill(0xFFFFFF);
		this.graphics.drawCircle(0,0,4);
		this.graphics.endFill();
	}
}