/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nZVO
 */

s3dassspackage
{
    //http://liuyueyu.w61p.com:58/vini123/sounds/contents/蓝雨 - 谁是爱情里的主角.mp3
    import away3d.cameras.lenses.PerspectiveLens;
    import away3d.containers.ObjectContainer3D;
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.entities.SegmentSet;
    import away3d.filters.RadialBlurFilter3D;
    import away3d.primitives.LineSegment;
    
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.utils.getTimer;
    
    //[SWF(width="960",height="540",frameRate="60")]
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    
    //我的微信vinifly ，欢迎关注，谢谢
    
    public class LinesSphereEx extends View3D
    {
        
        //----------------------------------------------------------
        //
        //   Static Property 
        //
        //----------------------------------------------------------
        
        private static const parameters:Array = [[0.3, 0x0088FF, 1, 5, 1500],
        [0.1, 0x0099DD, 1, 2, 2000], 
        [0.7, 0x0066CC, 0.75, 1, 16000],
        [1.24, 0x005599, 0.5, 1, 2000], 
        [1.25, 0x6633FF, 0.8, 1, 16000], 
        [3.0, 0x404040, 0.75, 2, 1000], 
        [3.5, 0x808080, 0.5, 1, 1000], 
        [4.5, 0x444444, 0.25, 1, 1000], 
        [5.5, 0x808080, 0.125, 1, 1000]];
        
        private static const r:Number = 450;
        
        //----------------------------------------------------------
        //
        //   Constructor 
        //
        //----------------------------------------------------------
        
        public function LinesSphereEx()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            antiAlias = 2;
            backgroundColor = 0x000000;
            (camera.lens as PerspectiveLens).far = 500000;
            
            sphere = new ObjectContainer3D();
            scene.addChild(sphere);
            
            var list:Array = [];
            for (var i:int = 0; i < 16000; ++i)
            {
                var vector1:Vector3D = translateGeoCoords(360 * Math.random(), 360 * Math.random(), r);
                
                var vector2:Vector3D = vector1.clone();
                vector2.scaleBy(Math.random() * 0.1 + 1);
                
                list.push([vector1, vector2]);
            }
            
            for (i = 0; i < parameters.length; ++i)
            {
                var p:Array = parameters[i];
                
                var lines:SegmentSet = new SegmentSet();
                if (i < 4)
                    sphere.addChild(lines);
                else
                    scene.addChild(lines);
                
                lines.scaleX = lines.scaleY = lines.scaleZ = p[0];
                lines.rotationY = Math.random() * 360;
                
                for (var j:int = 0; j < p[4]; j++)
                {
                    var color:uint = ((0xFF * p[2]) << 24) + p[1];
                    
                    lines.addSegment(new LineSegment(list[j][0], list[j][1], color, 0x0, p[3]));
                }
                
                orijinalScales[i] = p[0];
                lineSegments[i] = lines;
            }
            
            // load music
            var sound:Sound = new Sound(new URLRequest("http://www.52yyue.16mb.com/lxpp/jynhznl.mp3"));
            soundChannel = sound.play(0, int.MAX_VALUE);
            
            //addChild(new AwayStats(this));
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            resizeHandler(null);
        
        }
        
        //----------------------------------------------------------
        //
        //   Property 
        //
        //----------------------------------------------------------
        
        private var cameraZ:Number = 1;
        private var inited:Boolean = false;
        private var lineSegments:Array = [];
        private var orijinalScales:Vector.<Number> = new Vector.<Number>();
        private var rotY:Number = 0;
        private var rotZ:Number = 0;
        private var soundChannel:SoundChannel;
        private var sphere:ObjectContainer3D;
        
        //----------------------------------------------------------
        //
        //   Function 
        //
        //----------------------------------------------------------
        
        private function resizeHandler(e:Event):void
        {
            this.width = stage.stageWidth;
            this.height = stage.stageHeight;
            
            var distance:Number = Vector3D.distance(new Vector3D(-1000, 500, 500), new Vector3D(0, 0, 0));
            (camera.lens as PerspectiveLens).fieldOfView = 2 * Math.atan2(Math.sqrt(this.width * this.width + this.height * this.height) / 2, distance) * 180 / Math.PI;
        }
        
        private function enterFrameHandler(ev:Event):void
        {
            if (!inited)
            {
                filters3d = [new RadialBlurFilter3D(6, 1.8, 1.0, -0.4)]
                inited = true;
            }
            
            var volume:Number = (soundChannel.leftPeak + soundChannel.rightPeak) / 2;
            
            // rotation move
            rotZ += (soundChannel.leftPeak - 0.2) * 0.04;
            rotY += (soundChannel.rightPeak - 0.1) * 0.05;
            
            
            sphere.scaleX = sphere.scaleY = sphere.scaleZ = cameraZ;
            
            var time:Number = getTimer();
            
            const speed:Array = [3, 4, 4.5, 1.5, 2, -2, 1, -1, 1, 1, 1, 1];
            
            for (var i:int = 0; i < lineSegments.length; i++)
            {
                var obj:SegmentSet = lineSegments[i] as SegmentSet;
                
                if (i < 5)
                {
                    obj.rotationY += (rotY * 180 / Math.PI * speed[i] - obj.rotationY) * 0.05;
                    obj.rotationX += ((rotZ + rotY) * 0.3 * 180 / Math.PI * speed[i] - obj.rotationX) * 0.05;
                }
                
                if (i < 5)
                    obj.scaleX = obj.scaleY = obj.scaleZ = (orijinalScales[i] * (i / 2 + 1) * (1 + 0.5 * Math.sin(time / 1500)));
            }
            
            camera.x = 1600 * Math.sin(time / 2000);
            camera.z = 1600 * Math.cos(time / 2000);
            camera.lookAt(new Vector3D(0, 0, 0));
            
            render();
        }
        
        /**
         * 経度と緯度から位置を算出します。
         * @param latitude    緯度
         * @param longitude    経度
         * @param radius    半径
         * @return 位置情報
         */
        private function translateGeoCoords(latitude:Number, longitude:Number, radius:Number):Vector3D
        {
            const latitudeDegreeOffset:Number = 90;
            const longitudeDegreeOffset:Number = -90;
            
            latitude = Math.PI * latitude / 180;
            longitude = Math.PI * longitude / 180;
            
            latitude -= (latitudeDegreeOffset * (Math.PI / 180));
            longitude -= (longitudeDegreeOffset * (Math.PI / 180));
            
            var x:Number = radius * Math.sin(latitude) * Math.cos(longitude);
            var y:Number = radius * Math.cos(latitude);
            var z:Number = radius * Math.sin(latitude) * Math.sin(longitude);
            
            return new Vector3D(x, z, y);
        }
    }
}
