/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nZ5E
 */

package {
    
    [SWF(width=950, height=600)]
    
    import flash.display.*;
    import flash.events.*;
    import flash.external.*;
    import flash.text.*;
    

    public class JS01 extends MovieClip {
        
        private var btn:Sprite;
        private var v0:Shape;
        private var submit:TextField;
        private var txt:TextField;
        
        
        public function JS01():void {
            
            btn = Sprite(addChild(new Sprite()));
            
            v0 = Shape(addChild(new Shape()));
            submit = TextField(btn.addChild(new TextField()));
            txt = TextField(addChild(new TextField()));
            
            v0.x = 700;
            v0.y = 220;
            
            submit.defaultTextFormat = new TextFormat("_sans", 12);
            
            with (graphics) beginFill(0xefefef), drawRect(0,0,stage.stageWidth, stage.stageHeight);
            
            with (btn.graphics) beginFill(0x666666), drawRect(0,0,100,20);
            with(btn) x=220, y=330, buttonMode = true;
            
            with(submit) textColor=0xFFFFFF, width=100, autoSize="center";
            with(submit) mouseEnabled = false,    text="submit";
            
            with(txt) x = y = 20, type = "input", multiline=true;
            with(txt) width = 300, height = 300, border = true, background = 0xFFFFFF;
            
            txt.defaultTextFormat = new TextFormat("Monaco", 12);
            txt.text = "enter text";
            txt.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            
            btn.addEventListener(MouseEvent.ROLL_OVER, function():void{
                with(btn.graphics) clear(), beginFill(0x222222), drawRect(0,0,100,20);
            });
                
                btn.addEventListener(MouseEvent.ROLL_OUT, function():void{
                with(btn.graphics) clear(), beginFill(0x666666), drawRect(0,0,100,20);
            });
            
            
            btn.addEventListener(MouseEvent.CLICK, function():void{
                var res:*= ExternalInterface.call("function(){ plot=[]; colors=[]; " + txt.text + " return {plot:plot, colors:colors};}");
                render((res == null) ? {plot:[], colors:[]} : res);
            });
                        
        }
        

       private  function render(obj:Object):void{
            var plot:Array = obj.plot;
            var colors:Array = obj.colors;
            var leng:int = plot.length;
            
            v0.graphics.clear();
            
            var inc:int = 0;
            
            v0.graphics.moveTo(plot[0], plot[1]);
            
            for (var i0:int = 2; i0<leng; i0+=2){
                v0.graphics.lineStyle(0, colors[inc++]);
                v0.graphics.lineTo(plot[i0], plot[i0 + 1]);
            }
            
        }
        
        
        private function onDown(evt:MouseEvent):void{
            txt.text = "";
            txt.removeEventListener(MouseEvent.MOUSE_DOWN, onDown);
        }

    }
    
}
