/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nWCo
 */

// forked from FLASHMAFIA's Persistence
package {
    import flash.display.BlendMode;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.InterpolationMethod;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    [SWF(width='465', height='465')]
    public class Persistence extends Sprite
    {
        private const NUM_TRAILS : uint = 6;
        private const PERSISTENCE : uint = 1.618 << 3.0; //3;
        /* */
        private var coords : Vector.<Vector.<Number>>;
        private var cmds : Vector.<int>;
        private var ang : Number = 0.0;
        private var ogr : Graphics;

        function Persistence()
        {
            stage.stageFocusRect =  tabChildren  =  tabEnabled  =  mouseChildren  =  mouseEnabled  =  false;
            stage.scaleMode      =  StageScaleMode.NO_SCALE;
            stage.align          =  StageAlign.TOP;
            stage.quality        =  StageQuality.HIGH; //.MEDIUM;
            stage.frameRate      =  90;  //64;
            opaqueBackground     =  0x0;
            stage.fullScreenSourceRect = new Rectangle(0, 0, 465, 465);
            // ENTRY POINT:
            
            
            var bg : Shape = new Shape();
            addChild(bg);

            var mtx : Matrix = new Matrix();
            mtx.createGradientBox(465, 465);

            bg.graphics.beginGradientFill(GradientType.RADIAL, [0x801040, 0x400420], [1, 1], [0, 255], mtx, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
            bg.graphics.drawRect(0, 0, 465, 465);
            bg.graphics.endFill();

            var oshp : Shape = new Shape();
            oshp.filters = [new GlowFilter(0xFF0080, 1.0, 32.0, 32.0, 3, BitmapFilterQuality.MEDIUM)];
            oshp.blendMode = BlendMode.ADD;
            addChild(oshp);

            ogr = oshp.graphics;

            cmds = new Vector.<int>(PERSISTENCE, true);
            cmds[0] = 1;

            var n : uint = 1;
            while (n < cmds.length)
            {
                cmds[n] = 2;
                n++;
            }

            coords = new Vector.<Vector.<Number>>(NUM_TRAILS, true);

            n = coords.length;
            while (n-- != 0)
            {
                coords[n] = new Vector.<Number>();
                
                var nn : uint = (PERSISTENCE << 1);
                while (nn-- != 0)
                {
                    coords[n].push(0.0);
                }
            }

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            ogr.clear();
            ogr.lineStyle(3.5, 0xFF0080, 1.0, false, 'none', 'none');

            ang += 3.141592653589793 / (stage.frameRate);
            
            var a : Number = ang;
            var sweep : Number = 3.141592653589793 * 2 / NUM_TRAILS;

            var cx : Number = stage.mouseX;
            var cy : Number = stage.mouseY;

            for each (var coord : Vector.<Number> in coords)
            {
                a += sweep;

                var inertx : Number = 0.96 * (coord[0] += (coord[0] -= coord[2])) + ((cx + 128.0 * cos(a)) * 0.04);
                var inerty : Number = 0.96 * (coord[1] += (coord[1] -= coord[3])) + ((cy + 128.0 * sin(a)) * 0.04);

                coord.unshift(inerty);
                coord.unshift(inertx);
                coord.length = (PERSISTENCE << 1);

                ogr.drawPath(cmds, coord);
            }
        }

        private function sin(a : Number) : Number
        {
            a %= 6.283185307179586;
            if (a > 3.141592653589793) a -= 6.283185307179586;
            // if (a < -3.141592653589793) a += 6.283185307179586;
            var s : Number = (a <= 0) ? (1.27323954 * a + 0.405284735 * a * a) : (1.27323954 * a - 0.405284735 * a * a);
            return (s < 0) ? (0.225 * (s * -s - s) + s) : (0.225 * (s * s - s) + s);
        }

        private function cos(a : Number) : Number
        {
            return sin(a + 1.5707963267948966);
        }
    }
}