/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nW8B
 */

package 
{
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	/**
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class PoissonDisk extends Sprite
	{
		static private var cellSize:Number;
		
		static private var min_dist_square:Number;
		
		static private var samplePoints:Vector.<Point>;
		
		public function PoissonDisk() { }
		
		static public function distribute( rect:Rectangle, min_dist:Number = 10, count:int = 50 ):Vector.<Point>
		{
			
			
			min_dist_square = min_dist * min_dist;
			
			var max:int = ( rect.width / min_dist ) * ( rect.height / min_dist );
			
			if ( count > max * .5 ) count = max * .5;
			
			var p:Point = new Point( rect.width / 2 , rect.height / 2 );
			var np:Point;
			
			samplePoints = Vector.<Point>( [ p ] );
			
			
			while ( samplePoints.length < count )
			{
				
				np = new Point( Math.random() * rect.width, Math.random() * rect.height );
				
				if ( rect.containsPoint( np ) )
				{
					if ( !isAround( samplePoints, np ) )
					{
						
						samplePoints.push( np );
						
					}
				}
			}
			
			return samplePoints;
		}
		
		
		static private function isAround( points:Vector.<Point>, np:Point ):Boolean
		{
			
			var p:Point;
			var dx:Number, dy:Number;
			var x:int, y:int;
			for each( p in points )
			{
				dx = np.x - p.x;
				dy = np.y - p.y;
				if ( ( dx * dx + dy * dy ) < min_dist_square ) return true;
			}
			
			return false;
		}
		
	}

}