/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nW5Q
 */

// forked from umi_kappa's forked from: JigLibFlash Test
// forked from tkinjo's JigLibFlash Test
package  
{
	/**
	 * JigLibFlash が Papervision 以外の 3D エンジンに対応して、書き方が変わっていたので新 JigLibFlash をいじってみた。
	 */
	 
	 /*
	 	初めて使うので、自分なりにわかりやすいように編集。
	 */
	
	import flash.events.Event;
	
	import jiglib.physics.RigidBody;
	import jiglib.plugin.papervision3d.Papervision3DPhysics;
	
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.view.*;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends BasicView
	{
		private const speed:Number = 10;
		
		private var physics:Papervision3DPhysics;
		
		public function Main() 
		{
			
			// カメラ設定
			 camera.z = 500;
			 camera.y = 500;
			 camera.x = 700;
			 camera.lookAt( DisplayObject3D.ZERO );
			
			/*---------------
				jiglib 設定
			---------------*/
			physics = new Papervision3DPhysics( scene, speed );
			
			// 地面の作成
			var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
			var ground:RigidBody = physics.createGround( wireframeMaterial, 1000, 0 );
			
			// ボックスの作成
			var materials:MaterialsList = new MaterialsList();
			materials.addMaterial( new WireframeMaterial( 0 ), "all" );
			
			var box:RigidBody;
			for (var i:int = 0; i < 5; i++) {
				box = physics.createCube( materials, 100, 100, 100 );
				box.y = 300 * ( i + 1 );
			}
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
			
			//レンダリング
			startRendering();
		}
		
		private function enterFrameHandler( event:Event ):void {
			physics.step();
		}
	}
}