/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nVwN
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class BallFollowingMouse extends Sprite {
        public var ballCount:uint = 50;
        private var speed:Number = 0.2;
        
        public function BallFollowingMouse() {
            for(var i:uint=0;i<ballCount;i++){
                addChild(new Ball(this, 200));
            }
            addEventListener(Event.ENTER_FRAME, followMouse);
        }
        
        private function followMouse(e:Event):void{
            dispatchEvent(new BallEvent(BallEvent.FOLLOW, mouseX, mouseY, speed));
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;

class Ball extends Sprite {
    
    private var angle:Number;
    private var radius:Number;
    private var sizeRate:Number = 0.1;
    private const deceleration:Number = 0.2;
    
    public function Ball(timeline:Sprite, maxRadius:Number){
        var randomRate:Number = Math.random();
        angle = 2 * Math.PI * Math.random();
        radius = maxRadius * randomRate;
        createBall(randomRate);
        
        timeline.addEventListener(BallEvent.FOLLOW, follow);
    }
    
    private function createBall(randomRate:Number):void{
        var myGraphics:Graphics = graphics;
        myGraphics.beginFill(Math.floor(0XFFFFFF*randomRate)+1);
        myGraphics.drawCircle(0,0,radius * sizeRate);
        alpha = 1 - randomRate;
    }
    
    private function follow(e:BallEvent):void{
        var randomRate:Number = Math.random();
        angle += e.speed;
        angle %= Math.PI*2;
        var nX:Number = e.targetX + radius*Math.cos(angle);
        var nY:Number = e.targetY + radius*Math.sin(angle);
        x += (nX - x) * deceleration * randomRate;
        y += (nY - y) * deceleration * randomRate;
    }
}

import flash.events.Event;

class BallEvent extends Event {
    
    public static const FOLLOW:String = "follow";
    private var _targetX:Number;
    private var _targetY:Number;
    private var _speed:Number;
    
    public function BallEvent(event_str:String, myTargetX:Number, myTargetY:Number, mySpeed:Number){
        super(event_str);
        _targetX = myTargetX;
        _targetY = myTargetY;
        _speed = mySpeed;
    }
    
    public override function toString():String{
        return formatToString("BallEvent", "type", "bubbles", "cancelable", "eventPhase", "targetX", "targetY", "speed");
    }
    
    public override function clone():Event{
        return new BallEvent(type, targetX, targetY, speed);
    }
    
    public function get targetX():Number{
        return _targetX;
    }
    
    public function get targetY():Number{
        return _targetY;
    }
    
    public function get speed():Number{
        return _speed;
    }
}



