/**
 * Copyright terra1119 ( http://wonderfl.net/user/terra1119 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nVfo
 */

// Sample for event trigger
package {
    import flash.display.*;
    import flash.events.*;
    import org.si.sion.*;
    import org.si.sion.events.*;
    
    
    public class EventTrigger extends Sprite {
        // driver
        public var driver:SiONDriver = new SiONDriver();
        
        // MML data
        public var mainMelody:SiONData;
		
		public var s_btn:SimpleButton;
		public var e_btn:SimpleButton;

        
        // constructor
        public function EventTrigger() {
            // compile with event trigger command (%t)
            mainMelody = driver.compile("%t0,1,1 t100 l8 [ccggaag4 ffeeddc4 | [ggffeed4]2 ]2");
            
            // listen triggers
            driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME,  _onNoteOn);
            driver.addEventListener(SiONTrackEvent.NOTE_OFF_FRAME, _onNoteOff);
            //addEventListener("enterFrame", _onEnterFrame);
            
            // play main melody
            //driver.play(mainMelody);
			s_btn = new SimpleButton(40, 20, "start");
			e_btn = new SimpleButton(40, 20);
			addChild(s_btn);
			addChild(e_btn);
			s_btn.x = 200;
			s_btn.y = 200;
			s_btn.addEventListener(MouseEvent.CLICK, onClick);
        }
		
		private function onClick(e:MouseEvent):void 
		{
			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
			driver.play(mainMelody);
		}
        
        
        // This event dispatched when note on
        private function _onNoteOn(e:SiONTrackEvent) : void {
            _createNoteShape(e.note);
        }
        
        
        // This event dispatched when note off
        private function _onNoteOff(e:SiONTrackEvent) : void {
        }
        
        
        // create shape
        private function _createNoteShape(noteNumber:int) : Shape {
            var shape:Shape = new Shape();
            shape.graphics.beginFill([0xff8080, 0x80ff80, 0x8080ff, 0xffff80][int(Math.random()*4)]);
            shape.graphics.drawCircle(0, 0, Math.random()*20+10);
            shape.graphics.endFill();
            shape.x = (noteNumber - 60) * 30 + 100;
            shape.y = 300;
            addChild(shape);
            return shape;
        }
        
        
        // on each frame
        private function _onEnterFrame(e:Event) : void {
            var imax:int = numChildren;
            for (var i:int=0; i<imax; i++) {
                var child:DisplayObject = getChildAt(i);
                child.y -= 2;
                child.alpha *= 0.98;
                if (child.y < -30 || child.alpha < 0.1) {
                    removeChild(child);
                    imax--;
                    i--;
                }
            }
        }
    }
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
class SimpleButton extends Sprite {
	public var w:uint;
	public var h:uint; 
	public var color:uint;
	public var str:String;
	private var tf:TextField;
	
	public function SimpleButton(w:uint, h:uint, str:String=null, color:uint = 0x000000) {
		this.w = w;
		this.h = h;
		this.color = color;
		this.str = str;
		init();
	}
	
	private function init():void
	{
		/*
		tf = new TextField();
		tf.textColor = 0xffffff;
		tf.autoSize = TextFieldAutoSize.CENTER;
		tf.x = 0;
		tf.y = 0;
		tf.width = w;
		tf.height = h;
		tf.text = str;
		*/
		//this.addChild(tf);
		graphics.beginFill(color);
		graphics.drawRect(w * 0.5, h * 0.5, w, h);
		graphics.endFill();
		buttonMode = true;
	}
}
