/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nVTl
 */

// forked from ikoan's ikoan's practice：グラデーション
package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.GradientType;    // グラデーションのタイプ指定に用いる
    import flash.events.Event;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        // スプライト
        private var redCircle:Sprite = new Sprite();

        // グラデーションで用いる配列セット
        private var colors:Array = [0x0000ff, 0xff0000, 0x00ff00, 0x0000ff];
        private var alphas:Array = [1, 1, 1, 1];
        private var ratios:Array = [0, 85, 170, 255];
        private var circleX:int  = 0;        // サークル位置
        private var circleY:int  = 0;        // サークル位置
        private var moveX:int    = 5;        // 移動速度初期値
        private var moveY:int    = 5;        // 移動速度初期値
        
        public function FlashTest() {
            // 以下スプライトの設定
            
            // nsmt's <赤い円を作成>より
            //redCircle.graphics.beginFill(0xff0000);
            
            // サークルをステージにセット
            addChild(redCircle);
            
            // 円の標準描画位置を指定
            redCircle.x = stage.stageWidth/2;
            redCircle.y = stage.stageHeight/2;
            
            addEventListener(Event.ENTER_FRAME, update) 
        }
        
        // グラデーションのアニメーション
        private function animGradientColor():void{
            var text:TextField = new TextField();
            text.background = true;
            
            if(ratios[0] >= 40)
                return;
            for(var n:int=0 ; n<2 ; n++){
                ratios[n] += 1;
            }
            if( ratios[2] > 254){
                shiftColor();
                shiftRatio();
            }
        }
        
        // カラー配列をシフト
        private function shiftColor():void{
            var tempColor:int = colors[3];
            colors[3] = colors[2];
            colors[2] = colors[1];
            colors[1] = tempColor;
            colors[0] = tempColor;
        }
        
        // 色分布比率配列をシフト
        private function shiftRatio():void{
            ratios[2] = ratios[1];
            ratios[1] = ratios[0];
            ratios[0] = 0;
        }
        
        // グラデーションセット＆ドロー
        private function setGradientColor():void{
            // グラデーションセット            
            redCircle.graphics.beginGradientFill(
                GradientType.RADIAL,    // グラデーションタイプ
                colors,                 // 色指定
                alphas,                 // アルファ値
                ratios                  // 色描画領域
                );
                
            // 円を書きます
            redCircle.graphics.drawCircle(0, 0, 100);
            redCircle.graphics.endFill();
        }
        
        // 円の移動
        private function moveCircle():void{
            circleX += moveX;
            circleY += moveY;
            
            if( circleX > stage.stageWidth ){
                moveX = -5;
            }
            if( circleX < 0 ){
                moveX = 5;
            }

            if( circleY > stage.stageHeight ){
                moveY = -5;
            }
            if( circleX < 0 ){
                moveY = 5;
            }

            redCircle.x = circleX;
            redCircle.y = circleY;
        }
        
        private function update(event:Event):void{
            animGradientColor();
            setGradientColor();
            //moveCircle();
        }
    }
}