/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nVPZ
 */

// forked from mex's 【AS100本ノック】13回目：アルファベット
/**
 * 何も思い浮かばないので、
 * とりあえず飛ばしてみました、、、
 * *A-Zキーで放出
 * *マウスダウンで呼び寄せ
 * --
 * AS100本ノック
 * 13回目のお題は「アルファベット」
 * あなたなりの「アルファベット」を表現してください。
 **/
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix3D;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.utils.Timer;
	import frocessing.color.ColorHSV;

	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
	public class Alphabet extends Sprite
	{
		public static const STAGE_WIDTH:uint = 465;
		public static const STAGE_HEIGHT:uint = 465;
		private static const _TIMER_DELAY:uint = 75;
		private static var _MOUSE3D:Matrix3D;
		private static var _IS_TRAC_MOUSE:Boolean;
		private var _helpText:TextField;
		private var _container:Sprite;
		private var _canvas:Bitmap;
		private var _canvasData:BitmapData;
		private var _item:BitmapItem;
		private var _items:Vector.<BitmapItem>;
		private var _timer:Timer;
		private var _isCycle:Boolean;
		private var _chars:Vector.<uint>;
		private var _hsv:ColorHSV;
		private var _angle:uint;
		private var _mouseVec:Vector3D;
		private var _isTrackMouse:Boolean;

		public function Alphabet()
		{
			init();
		}
		private function init():void
		{
			_helpText = new TextField();
			_helpText.autoSize = TextFieldAutoSize.LEFT;
			_helpText.textColor = 0xFFFFFF;
			_helpText.selectable = false;
			_helpText.text = "press A-Z key.";
			_helpText.x = stage.stageWidth/2 - _helpText.width/2;
			_helpText.y = stage.stageHeight/2 - _helpText.height/2;
			addChild(_helpText);

			_container = new Sprite;

			_canvasData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			_canvas = new Bitmap(_canvasData);
			addChild(_canvas);

			_hsv = new ColorHSV(0, 0.9, 0.9, 0.9);
			_chars = new Vector.<uint>;

			_items = new Vector.<BitmapItem>;
			_timer = new Timer(_TIMER_DELAY, 0);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);

			_MOUSE3D = new Matrix3D;
			_mouseVec = _MOUSE3D.position;
			_mouseVec.z = -BitmapItem.ZERO.z;

			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}

		private function keyDownHandler(event:KeyboardEvent):void
		{
			_helpText.visible = false;
			if(65 <= event.keyCode && event.keyCode <= 90)
			{
				if(_chars.indexOf(event.keyCode) < 0)
				{
					_chars.push(event.keyCode);
				}
				if(!_isCycle)
				{
					_isCycle = true;
					_timer.dispatchEvent(new TimerEvent(TimerEvent.TIMER));
					_timer.start();
				}
			}
		}

		private function keyUpHandler(event:KeyboardEvent):void
		{
			if(65 <= event.keyCode && event.keyCode <= 90)
			{
				if(_chars.indexOf(event.keyCode) > -1)
				{
					_chars = _chars.filter(function(item:uint, index:int, vector:Vector.<uint>):Boolean
					{
						return item != event.keyCode;
					});
				}
				if(_chars.length < 1)
				{
					_timer.stop();
					_timer.reset();
					_isCycle = false;
				}
			}
		}

		private function timerHandler(event:TimerEvent):void
		{
			var char:uint = _chars.shift();
			_chars.push(char);
			_item = new BitmapItem(String.fromCharCode(char).toUpperCase());
			_container.addChild(_item);
			_items.push(_item);
		}

		private function mouseDownHandler(event:MouseEvent):void
		{
			_IS_TRAC_MOUSE = true;
		}

		private function mouseUpHandler(event:MouseEvent):void
		{
			var item:BitmapItem;
			for each(item in _items)
			{
				_container.removeChild(item);
			}
			_items = new Vector.<BitmapItem>;
			_IS_TRAC_MOUSE = false;
		}

		private function blend():void
		{
			_canvasData.colorTransform(_canvasData.rect, new ColorTransform(1, 1, 1, 0.96, 0, 0, 0, 10));
			_canvasData.applyFilter(_canvasData, _canvasData.rect, new Point(0, 0), new BlurFilter(8, 8));

			_hsv.h = _angle;
			_container.filters = [
				new GlowFilter(_hsv.value, 1, 8, 8, 1, 1, true, false)
			];
			_canvasData.draw(_container);
		}

		private function enterFrameHandler(event:Event):void
		{
			var item:BitmapItem;
			for each(item in _items)
			{
				if(item.isActive())
				{
					item.next();
				}
				else
				{
					_container.removeChild(item);
				}
			}
			_items = _items.filter(function(item:BitmapItem, index:int, vector:Vector.<BitmapItem>):Boolean
			{
				return item.parent == _container;
			});
			_angle = ++_angle%360;
			_mouseVec.x = stage.mouseX;
			_mouseVec.y = stage.mouseY;
			_MOUSE3D.position = _mouseVec;
			blend();
		}

		public static function get mouse3d():Matrix3D
		{
			return _MOUSE3D;
		}

		public static function get isTrackMouse():Boolean
		{
			return _IS_TRAC_MOUSE;
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.filters.BlurFilter;
import flash.geom.Matrix3D;
import flash.geom.Point;
import flash.geom.Vector3D;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
class BitmapItem extends Bitmap
{
	public static const ZERO:Vector3D = new Vector3D(Alphabet.STAGE_WIDTH/2, Alphabet.STAGE_HEIGHT, Alphabet.STAGE_WIDTH/2);
	private static var _TF:TextField;
	private static var _TFM:TextFormat;
	private static const BASE_POWER:Number = 50;
	private static const MARGIN:Number = 40;
	private static const ROTATE_MARGIN:Number = 8;
	private static const FRICTION:Number = 0.95;
	private static const GRAVITY:Number = 1.5;
	private var _pX:Number;
	private var _pY:Number;
	private var _pZ:Number;
	private var _pos3D:Vector3D;
	private var _rotate3D:Vector3D;
	private var _lifeCount:uint = 100;
	private var _str:String;

	public function BitmapItem(str:String)
	{
		_str = str;
		init();
	}
	public function init():void
	{
		if(!_TF)
		{
			_TF = new TextField();
			_TFM = _TF.getTextFormat();
			_TFM.font = "Arial, Verdana";
			_TFM.size = 50;
			_TF.autoSize = TextFieldAutoSize.LEFT;
			_TF.textColor = 0xFFFFFF;
		}
		_pos3D = new Vector3D;
		_pX = MARGIN*Math.random() - MARGIN/2;
		_pY = MARGIN*Math.random() - MARGIN/2 - BASE_POWER;
		_pZ = MARGIN*Math.random() - MARGIN/2;
		x = _pos3D.x = ZERO.x;
		y = _pos3D.y = ZERO.y;
		z = _pos3D.z = ZERO.z;

		_rotate3D = new Vector3D;
		_rotate3D.x = ROTATE_MARGIN*Math.random() - ROTATE_MARGIN/2;
		_rotate3D.y = ROTATE_MARGIN*Math.random() - ROTATE_MARGIN/2;
		_rotate3D.z = ROTATE_MARGIN*Math.random() - ROTATE_MARGIN/2;

		writeText(_str);
	}

	private function writeText(str:String):void
	{
		_TF.text = str;
		_TF.setTextFormat(_TFM);
		bitmapData = new BitmapData(_TF.width, _TF.height, true, 0x00000000);
		bitmapData.draw(_TF);
	}

	public function next():void
	{
		_pX = _pX * FRICTION;
		_pY = _pY * FRICTION + GRAVITY;
		_pZ = _pZ * FRICTION;
		transform.matrix3D.appendTranslation(-_pos3D.x, -_pos3D.y, -_pos3D.z);
		transform.matrix3D.appendRotation(_rotate3D.x, Vector3D.X_AXIS);
		transform.matrix3D.appendRotation(_rotate3D.y, Vector3D.Y_AXIS);
		transform.matrix3D.appendRotation(_rotate3D.z, Vector3D.Z_AXIS);
		_pos3D.x += _pX;
		_pos3D.y += _pY;
		_pos3D.z += _pZ;
		transform.matrix3D.appendTranslation(_pos3D.x, _pos3D.y, _pos3D.z);
		if(Alphabet.isTrackMouse)
		{
			transform.matrix3D.interpolateTo(Alphabet.mouse3d, 0.5);
		}
		else
		{
			transform.matrix3D.appendRotation(3, Vector3D.X_AXIS);
		}
	}

	public function isActive():Boolean
	{
		if(_lifeCount > 0)
		{
			_lifeCount--;
			return true;
		}
		return false;
	}
}
