/**
 * Copyright CoremindJP ( http://wonderfl.net/user/CoremindJP )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nV7p
 */

package {
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.utils.setInterval;
    import flash.events.TimerEvent;
    /**
     * 内部でどんなに高速に回し(BitmapDataの書き換え等)ても
     * ステージのFPSに依存してレンダリングされると言う事に最近気づいて
     * どうにか出来ないかとググったらこんなメソッドが！
     * TimerEvent.updateAfterEvent()すばらしい！
     */
    public class FlashTest extends Sprite {

        private var overwriteFPS:Boolean;
        private var btn:Sprite;
        private var cvs:Bitmap;
        private var e:TimerEvent;
        private var vector:int;
        
        public function FlashTest() {
            
            //ステージのFPSを1にする。
            this.stage.frameRate = 0;
            
            //検証用bmp作成
            addChild(cvs = new Bitmap());
            cvs.x  = 200;
            cvs.y  = 200;
            vector = -1;
            
            //イベント作成
            e = new TimerEvent(TimerEvent.TIMER);
            
            //タイマーでメソッドを呼ぶ速度はFPS60
            setInterval(draw, 1000 / 60);
            
            overwriteFPS = false;
            
            //切り替えボタン
            var _tf:TextField = new TextField();
            _tf.textColor    = 0xFFFFFF;
            _tf.mouseEnabled = false;
            _tf.selectable   = false;
            _tf.text = "overwriteFPS";
           
            addChild(btn = new Sprite());
            btn.x = 200;
            btn.y = 300;
            btn.addChild(_tf);
            btn.buttonMode = true;
            btn.graphics.beginFill(0);
            btn.graphics.drawRect(0, 0, 70, 20);
            btn.graphics.endFill();
            btn.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
                {
                    overwriteFPS ? overwriteFPS = false: overwriteFPS = true;
                });
         }
        
        private function draw():void
        {
            //ビットマップの更新
            cvs.bitmapData = new BitmapData(65, 65, false, Math.random() * 0xFFFFFF);

            if (cvs.x == 0)
                vector = 1;
            else
            if (cvs.x == 400)
                vector =-1;
                
            cvs.x += vector;
            
            //このメソッドを叩かないとFPS1の速度で描画される。
            if (overwriteFPS)
                e.updateAfterEvent();
        }

        
        
        
    }
}