/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nUyv
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	
	[SWF(width = 465, height = 465, frameRate = 30, backgroundColor = "#FFFFFF")]
	
	/**
	 * 入力値を変換するTextFieldのサンプル
	 *  ここでは、アルファベット以外の入力を排除し、アルファベットは常に全角大文字に変換しています。
	 * @author H.Horiuchi
	 */
	public class Main extends Sprite 
	{
		private var inputField:TextField = new TextField();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			inputField.type = TextFieldType.INPUT;
			inputField.autoSize = TextFieldAutoSize.LEFT;
			inputField.x = 20;
			inputField.y = 20;
			inputField.border = true;
			inputField.addEventListener(TextEvent.TEXT_INPUT, onTextInput);
			this.addChild(inputField);
		}
		
		private function onTextInput(event:TextEvent):void
		{
			event.preventDefault();
			var input:String = event.text.toUpperCase();	// 全て大文字に
			input = input.replace(/[^A-ZＡ-Ｚ]/g, "");	// アルファベット以外は削除
			input = input.replace(/[A-Z]/g, function():String {
				var charCode:Number = arguments[0].charCodeAt(0);
				return String.fromCharCode(charCode - 0x41 + 0xff21);	// 'A'->'Ａ'
			});
			var oldText:String = inputField.text;
			inputField.text = oldText.substring(0, inputField.selectionBeginIndex)
							+ input
							+ oldText.substr(inputField.selectionEndIndex);
			inputField.setSelection(inputField.selectionBeginIndex + input.length,
					inputField.selectionBeginIndex + input.length);
		}
	}
}
