package  {
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	/**
	* Tribute to aokijun.
	* @see http://www.youtube.com/watch?v=9fQh_PqVsu8
	* 
	* The code is overcomplicated; by all means, feel free to simplify :)
	* @license WTFPLv2
	* 
	* Soundtrack: Lullaby for a Nightmare (Andrew Duke's Crispy Creepy Crawly Alien Funk Mix)
	* @see http://www.beatsdigital.com/index.php?track_id=393048
	*/
	public class Television extends Sprite {
		
		public function Television () {
			var loader:Loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, grabImage);
			loader.load (new URLRequest ("http://assets.wonderfl.net/images/related_images/7/73/7313/7313178b331bb26185fd65a19f76fecb03ffdb3d"),
				new LoaderContext (true));
		}

		private var image:BitmapData;
		private var screen:BitmapData;
		private var targetRect:Rectangle;
		private var noise:BitmapData;
		private function grabImage (e:Event):void {
			image = e.target.content.bitmapData;
			screen = new BitmapData (465, 465, false, 0);

			// x 230-to-368, y 62-to-161
			targetRect = new Rectangle (230, 62, 368 - 230, 161 - 62);
			noise = new BitmapData (targetRect.width, targetRect.height, false);

			var s:Number = 465 / image.height;
			screen.draw (image,
				new Matrix (s, 0, 0, s, 465 * 0.5 - s * (targetRect.x + 0.5 * targetRect.width)),
				null, null, null, true);
			graphics.beginBitmapFill (screen); graphics.drawRect (0, 0, 465, 465);

			stage.addEventListener (Event.ENTER_FRAME, makeNoise);

			// wait for clicky
			stage.addEventListener (MouseEvent.CLICK, click);
		}

		private function makeNoise (e:Event):void {
			noise.noise (int.MAX_VALUE * Math.random (), 100, 255, 7, true);
			var s:Number = 465 / image.height;
			screen.draw (noise,
				new Matrix (s, 0, 0, s, (465 - s * targetRect.width) * 0.5, s * targetRect.y),
				null, null, null, true);
		}

		private function click (e:MouseEvent):void {
			stage.removeEventListener (MouseEvent.CLICK, click);
			stage.removeEventListener (Event.ENTER_FRAME, makeNoise);
			stage.addEventListener (Event.ENTER_FRAME, zoom);

			// resize image for zoom
			var i:BitmapData = new BitmapData (image.height * targetRect.width / targetRect.height, image.height, false);
			var tx:Number = 0.5 * (i.width - targetRect.width) - targetRect.x;
			i.draw (image, new Matrix (1, 0, 0, 1, tx), null, null, null, true);
			image.dispose (); image = i; targetRect.x += tx;

			var sound:Sound = new Sound (new URLRequest ("http://s3.amazonaws.com/beatsdigital-previews/3/8/5/385312.mp3"));
			sound.play (0, int.MAX_VALUE);
		}

		private var t:Number = 1;
		private function zoom (e:Event):void {
			t -= 0.05; if (t < 0) t += 1;

			// first zoom matrix
			// t = 0 means scale image to screen height
			// t = 1 means scale targetRect to screen height
			var s:Number = 465 / image.height * (1 - t) + 465 / targetRect.height * t;
			var s1:Number = 465 / targetRect.height;
			var tx:Number = 465 * 0.5 - s * (targetRect.x + 0.5 * targetRect.width);
			var tx0:Number = 465 * 0.5 - (465 / image.height) * (targetRect.x + 0.5 * targetRect.width);
			var tx1:Number = 465 * 0.5 - s1 * (targetRect.x + 0.5 * targetRect.width);
			var zm:Matrix = new Matrix (s, 0, 0, s, tx, -s1 * targetRect.y * (tx - tx0) / (tx1 - tx0));

			// zoom matrix factor
			s = targetRect.height / image.height;
			var zmf:Matrix = new Matrix;zmf.scale (s, s);
			zmf.translate (targetRect.x, targetRect.y);

			while (zm.a > 0.01) {
				screen.draw (image, zm, null, null, null, true);
				var tmp:Matrix = zmf.clone (); tmp.concat (zm); zm = tmp;
			}
		}

	}
	
}