/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nTTv
 */

// forked from 9re's Buddhabrot
package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.utils.getTimer;
	import mx.utils.HSBColor;
	/**
	 * ...
	 * @author kobayashi-taro
	 */
	public class Buddhabrot extends Sprite
	{
		private static const W:int = 465;
		private static const H:int = 465;
		private static const TIME:int = 100;
		private static const LOOP_1_MAX:int = 1000;
		private static const BAIL_OUT:int = 200;
		private var _posRecord:Vector.<Number> = new Vector.<Number>();
		private var _image:Vector.<int> = new Vector.<int>();
		private var _bm:Bitmap;
		private var _width:int;
		private var _height:int;
		private var _bd:BitmapData;
		private var _loop_0:int;
		private var _loop_1:int;
		//private var _largest:int = 0;
		//private var _smallerst:int = 0xff;
		
		public function Buddhabrot() 
		{
			Wonderfl.disable_capture();
			_posRecord.length = BAIL_OUT;
			addEventListener(Event.ADDED_TO_STAGE, init);
			
			addChild(_bm = new Bitmap);
			
			Wonderfl.capture_delay(5);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.addEventListener(Event.RESIZE, function ():void {
				var w:int = stage.stageWidth;
				var h:int = stage.stageHeight;
				w = w ? w : W;
				h = h ? h : H;
				onResize(w, h);
			});
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.dispatchEvent(new Event(Event.RESIZE));
		}
		
		private function onResize(w:int, h:int):void
		{
			_loop_0 = _loop_1 = 0;
			_image.length = w * h;
			_width = w;
			_height = h;
			if (_bd) _bd.dispose();
			
			_bd = new BitmapData(w, h);
			_bm.bitmapData = _bd;
			
			if (!hasEventListener(Event.ENTER_FRAME))
				addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			var t:int = getTimer();
			var x:Number, y:Number;
			var tx:Number, ty:Number, ux:Number, uy:Number;
			var n:int, i:int, index:int, out:Boolean;
			var nx:int, ny:int, r:int;
			while (getTimer() - t < TIME) {
				// if the counter of the inner loop reaches to its max
				// increase that of the outter loop
				if (_loop_1 == LOOP_1_MAX) {
					_loop_1 = 0;
					++_loop_0;
				}
				// ends loop if the counter of the outter loop
				// reaches to its max
				if (_loop_0 == 1000000) {
					removeEventListener(Event.ENTER_FRAME, loop);
					break;
				}
				x = 6 * Math.random() - 3;
				y = 6 * Math.random() - 3;
				// calculate the escape state
				n = i = index = 0;
				tx = ty = 0;
				out = false;
				while (i < BAIL_OUT) {
					ux = tx * tx - ty * ty + x;
					uy = 2 * tx * ty + y;
					_posRecord[index++] = uy;
					_posRecord[index++] = ux;
					if (ux * ux + uy * uy > 10) {
						n = i;
						out = true;
						break;
					}
					tx = ux;
					ty = uy;
					++i;
				}
				if (out) {
					for (i = index = 0; i < n; ++i) {
						nx = _width * 0.3 * _posRecord[index++] + _width / 2;
						ny = _height * 0.3 *(_posRecord[index++] + 0.5) + _height / 2;
						if (nx >= 0 && ny >= 0 && nx < _width && ny < _height) {
							r = _image[ny * _height + nx]++;
							++r;
							_bd.setPixel(nx, ny, 0xff000000 | HSBColor.convertHSBtoRGB(r, 0.7, n / BAIL_OUT));
						}
					}
				}
			}
		}
	}
}


