/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nTNC
 */

package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    import flash.net.*;
    import flash.system.*;
    //[SWF(backgroundColor=0, width=465, height=465)]
    public class FlashTest extends Sprite {//==================================
        private var node1:ozmap = new ozmap();
        private var text1:TextField = new TextField();
        private var tf1:TextField = new TextField();
        public function FlashTest() {//----------------------------------------
            addChild(node1);
            var s:Sprite = new Sprite();
            s.graphics.lineStyle(1,0x000000);
            s.graphics.drawCircle(100,100,20);
            node1.map.addChild(s);
                        
            var roomID:String = "ozmap.chatroom";
            var minichat:MiniChat = new MiniChat(roomID);
            minichat.x = (465 - minichat.width);
            minichat.minimize();
            //minichat.y = (465 - minichat.height);
            addChild(minichat);
            //onLoad();
            //addEventListener(MouseEvent.CLICK,onLoad);
        }
        public function onLoad(e:MouseEvent=null):void{
            //var str:String = "http://swf.wonderfl.net/swf/usercode/a/a1/a1d7/a1d7c758c1dc7aa273cab8a8fb51df048afb9415.swf";//"http://swf.wonderfl.net/swf/usercode/d/d5/d59a/d59afcc4b32c1bc567e43466a6ca2ceae3dfe0b8.swf";
            //var str:String = "http://swf.wonderfl.net/swf/usercode/b/bc/bc19/bc196eb11cbf19e58ed463acafd53d3ca8fc9282.swf";
            var str:String = "http://ozworks.dip.jp/TubePlaylist.swf";
            var loader:Loader = new Loader();
            var url:URLRequest = new URLRequest(str);
            loader.load(url);
            loader.x = 100;
            addChild(loader);
        }

        
    }
}



//------ ozmap ------------------------------------------------------------------------

import flash.geom.Point;
import caurina.transitions.Tweener;
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.ui.*;
import flash.utils.*;

class ozmap extends Sprite{//======================================================
        
        private var scale:Number = 1;
        
        public var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        
        private var objStack:Array = new Array();
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        
        public var map:Sprite = new Sprite();//フィールド
        private var scalingPanel:Sprite = new Sprite();//ズーム、回転中心
        private var base:Sprite = new Sprite();//
        private var dragPanel:Sprite = new Sprite();//フィールドドラッグ用。マップへのマウス操作を受け取る
        //ozmap状態フラグ
        private const testMode:Boolean = true;//テスト表示

        private var mapBrowseMode:Boolean;//マップ移動操作
        private var mapDragMode:Boolean;//マップドラッグ中はtrue

        private   var t:TextField = new TextField();
        
        //コンストラクタ 
        public function ozmap():void{//----------------------------- 
            addChild(scalingPanel);
            scalingPanel.addChild(base);
            map.addChild(dragPanel);
            base.addChildAt(map,0); 
            
            dragPanel.doubleClickEnabled = true;
            browseOn();
            update();
            
            
            func();
        }
        //マップにオブジェクト配置
        public function addObject(target:DisplayObject,
                    x:Number=0,y:Number=0,rot:Number=0):void{
            map.addChild(target);
            
        }
        
        private function func():void{
            with(scalingPanel){//ズームの中心点
                graphics.beginFill(0xff0000,0.5);
                graphics.drawCircle(0,0,10);
                graphics.endFill();
            }
            with(base){
                graphics.beginFill(0x000000,0.5);
                graphics.drawRect(-10,-10,20,20);
                graphics.endFill();
            }
            with(dragPanel){
                graphics.beginFill(0x0000ff,0.5);
                graphics.drawRect(-10,-10,20,20);
                graphics.endFill();
            }
            with(map){
                graphics.beginFill(0x00ff00,0.5);
                graphics.drawRect(-10,-10,20,20);
                graphics.endFill();
            }
            addChild(t);
            t.text = "debug\n";
            t.selectable=false;
            t.width=300;
            
        }
        
        private function trace(str:String=""):void{
            t.appendText(str+"\n");
            t.scrollV = t.maxScrollV;
        }
        


        //マップ移動操作状態
        public function get IsBrowseMode():Boolean{//-----------------------------
            return mapBrowseMode;
        }
        //マップドラッグスクロール状態
        public function get IsDragMode():Boolean{//-----------------------------
            return mapDragMode;
        }
        
        
        //画面移動操作の受付　ON・OFF切り替え
        public function browseOn():void{//-----------------------------
            mapBrowseMode = true;
            //Mouse.hide();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.addEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            this.addEventListener(MouseEvent.MOUSE_MOVE,onMove)
            map.addChild(dragPanel);
        }
        
        public function browseOff():void{//-----------------------------
            wheel = 0;
            mapBrowseMode = false;
            //Mouse.show();
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.removeEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.removeEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.removeEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.removeChild(dragPanel);
        }
        
       

        
        //ダブルクリックでマップブラウズモード解除　⇒　オブジェクト操作モードに移行
        private function onDouble(e:MouseEvent=null):void{//-----------------------------
            browseOff();
            //ホイール操作でブラウズモードに移行
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,function():void{
                browseOn();
            });
        }


  
        //マップドラッグ
        private function down1(e:MouseEvent):void{//-----------------------------
            wheel=0;//ズーム操作ストップ
            
      　    e.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    stage.removeEventListener(Event.ENTER_FRAME,onFrame);
      　    e.stopPropagation();//イベントの伝播を止める
      　    
        }
        private function up1(event:MouseEvent):void{//-----------------------------
            event.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            event.stopPropagation();//イベントの伝播を止める
        }
        
        //マップドラッグ中
        private function onMove(e:MouseEvent):void{//-----------------------------
            update();
        }
    
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{//-----------------------------
            wheel += event.delta;
            if(wheel != 0)addEventListener(Event.ENTER_FRAME,onFrame);
            //else removeEventListener(Event.ENTER_FRAME,onFrame);
        }
  
        private function onFrame(e:Event):void {//-----------------------------
        //from on_wheel1
            //ズーム処理
            if(wheel==0)removeEventListener(Event.ENTER_FRAME,onFrame);
            on_zoom(1+(0.005*wheel));
        }
        
        
        //マップ表示位置を更新
        private function update(z:Number=1, x:Number=0, y:Number=0, a:Number=0):void{//-----------------------------
            var mX:int,mY:int;//ズーム中心位置
            if(1<=z){//ズームイン
                //マウスカーソルを中心にズームイン
                mX = mouseX;
                mY = mouseY;//カーソル位置    
            }
            else{//ズームアウト
                //画面を中心にズームアウトする
                mX = this.root.loaderInfo.width-mouseX;
                mY = this.root.loaderInfo.height-mouseY;//カーソル位置
            }
            
            //ズーム中心更新
            scalingPanel.x = mX;
            scalingPanel.y = mY; 
            //マップ位置更新
            base.x -= (mX-scrFocusX)/zoom;
            base.y -= (mY-scrFocusY)/zoom;
            //フォーカス位置更新
            scrFocusX = mX;
            scrFocusY = mY;
            

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            if(testMode)dragPanel.graphics.beginFill(0x00ffff,0.3);
            else dragPanel.graphics.beginFill(0x00ffff,0);
            var x1:Number = (map.x+map.parent.x)/map.scaleX;
            //var x2:Number = (map.x+map.parent.x)/zoom;
            var y1:Number = (map.y+map.parent.y)/map.scaleY;
            //var r1:Number = 600/map.scaleX;
            var r2:Number = 500/(zoom*map.scaleX);
            dragPanel.graphics.drawCircle(-x1,-y1,r2);
            dragPanel.graphics.endFill();
            
            
            //グリッドライン
            if(testMode){
                drawGrid();
            }
      
        }
        
        private function drawGrid(col:uint=0x00aa00):void{
            var i:int;
            var c:uint = col;
            const j:int = 32;
            for(i= -20-(map.y/j);i<30-(map.y/j);i++){
                if(Math.abs(i)%2 == 1)dragPanel.graphics.lineStyle(0,c,(zoom*0.5)-0.5);
                else dragPanel.graphics.lineStyle(0,c,0.5);
                dragPanel.graphics.moveTo((-1600-map.x)/map.scaleX , i*j/map.scaleX);
                dragPanel.graphics.lineTo((1600-map.x)/map.scaleX , i*j/map.scaleX);
            }
            for(i=-20-(map.x/j);i<30-(map.x/j);i++){
                if(Math.abs(i)%2 == 1)dragPanel.graphics.lineStyle(0,c,(zoom*0.5)-0.5);
                else dragPanel.graphics.lineStyle(0,c,0.5);
                dragPanel.graphics.moveTo(i*j/map.scaleX, (-1600-map.y)/map.scaleX);
                dragPanel.graphics.lineTo(i*j/map.scaleX, (1600-map.y)/map.scaleX);
            }
        }


        //マップの縮尺と座標を切り替える
        private function trans():void{
            //オブジェクトの座標、サイズ、角度を補正
            if(4 < zoom){

                map.scaleX = map.scaleY *= 2;//表示サイズ
                map.x *= 2; map.y *= 2;
                map.x += base.x; map.y += base.y;
                
                zoom /= 2;
                
            }
            else if(zoom < 0.5){
                //スケール更新
                map.scaleX = map.scaleY /= 2;
                //オフセット更新
                map.x -= base.x; map.y -= base.y;                
                map.x /= 2; map.y /= 2; 
                //ズーム更新
                zoom *= 2;
                
                //スケール更新
                map.scaleX = map.scaleY /= 2;
                //オフセット更新
                map.x -= base.x; map.y -= base.y;                
                map.x /= 2; map.y /= 2; 
                //ズーム更新
                zoom *= 2;
            }
        }

        
        private function on_zoom(z:Number=0):void{//-----------------------------
            if(z==0)return;
            update(z);//基準点更新
            zoom *= z;//ズーム
            //trans();
            //ズーム値更新
            scalingPanel.scaleX = scalingPanel.scaleY = zoom;        
          
        }//function
        
        
    }//class
    
    
 
 
    
/* ------------------------------------------------------------------------------------------------
 * MiniChat
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.media.*;
    import flash.text.*;
    import flash.ui.Keyboard;
    import net.user1.logger.Logger;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    import net.user1.reactor.UpdateLevels;
    
    //public 
    class MiniChat extends Sprite {
        private var _so:SharedObject;
        private var _isReactorShared:Boolean;
        private var _reactor:Reactor;
        private var _roomID:String;
        private var _room:Room;
        private var _messageLogSize:int;
        private var _messages:Vector.<String>;
        // ステータスバー
        private var _title:String;
        private var _statusBar:TextField;
        private var _minimizeButton:PushButton;
        // ウインドウ
        private var _window:Sprite;
        private var _messageDisplay:TextField;
        private var _nameInput:TextField;
        private var _messageInput:TextField;
        
        private var color1:uint = 0x000000;
        
        public function MiniChat(roomID:String, args:Object = null) {
            var now:Date = new Date();
            updateTime = now.getTime();
            
            _so = SharedObject.getLocal("MiniChat");
            if (!_so.data.name) { _so.data.name = "名無し"; }
            
            if (!args) { args = { }; }
            var logSize:int = ("logSize" in args) ? args["logSize"] : 10;
            var textColor:uint = ("textColor" in args) ? args["textColor"] : 0xFFFFFF;
            var backgroundColor:uint = ("backgroundColor" in args) ? args["backgroundColor"] : 0x404040;
            var defaultUserName:String = ("defaultUserName" in args) ? args["defaultUserName"] : _so.data.name;
            var initiallyMinimized:Boolean = ("initiallyMinimized" in args) ? args["initiallyMinimized"] : false;
            var draggable:Boolean = ("draggable" in args) ? args["draggable"] : true;
            var minimizable:Boolean = ("minimizable" in args) ? args["minimizable"] : true;
            var renamable:Boolean = ("renamable" in args) ? args["renamable"] : true;
            
            _isReactorShared = ("reactor" in args) ? true : false;
            _reactor = (_isReactorShared) ? args["reactor"] : new Reactor();
            _roomID = roomID;
            _messageLogSize = Math.max(1, logSize);
            _messages = new Vector.<String>();
            _title = ("title" in args) ? args["title"] : "現在の閲覧者数";
            
            // MinimalcompsのStyleを一時保存してから変更する
            var tempEmbedFonts:Boolean = Style.embedFonts;
            var tempFontName:String = Style.fontName;
            var tempFontSize:Number = Style.fontSize;
            Style.embedFonts = false;
            Style.fontName = "_sans";
            Style.fontSize = 12;
            
            // UIの作成
            addChild(_statusBar = createStatusBar(draggable, textColor, backgroundColor));
            
            _messageDisplay = createMessageDisplay(logSize);
            _window = createWindow(_messageDisplay.height);
            addChild(_window);
            _window.addChild(_messageDisplay);
            _nameInput = createInputText(0, _window.height - 19, 60, 8, defaultUserName);
            if (renamable) {
                _window.addChild(_nameInput);
                _window.addChild(_messageInput = createInputText(60, _nameInput.y, 170, 50, ""));
            }else {
                _window.addChild(createSayLabel(_window.height - 19));
                _window.addChild(_messageInput = createInputText(31, _window.height - 19, 200, 50, ""));
            }
            _messageInput.addEventListener(KeyboardEvent.KEY_DOWN, sendMessage);
            // MinimalcompsのStyleを元に戻す
            Style.embedFonts = tempEmbedFonts;
            Style.fontName = tempFontName;
            Style.fontSize = tempFontSize;
            if (minimizable) { addChild(_minimizeButton = createMinimizeButton()); }
            if (initiallyMinimized) { minimize(); }
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
        }
        
        //ステータスバー
        private function createStatusBar(draggable:Boolean, textColor:uint, backgroundColor:uint):TextField {
            var result:TextField = new TextField();
            result.width = 232; result.height = 20;
            var format:TextFormat = new TextFormat("_sans", 10, color1);
            format.align = TextFormatAlign.CENTER;
            result.defaultTextFormat = format;
            //result.background = true; result.backgroundColor = backgroundColor;
            //result.filters = [new BevelFilter(1, 45, 0xFFFFFF, 0.8, 0x000000, 0.8, 1, 1)];
            result.mouseEnabled = result.selectable = false;
            if (draggable) {
                result.mouseEnabled = true;
                result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
                result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);
            }
            return result;
        }
        private function startDragHandler(event:MouseEvent):void { startDrag(); }
        private function stopDragHandler(event:MouseEvent):void { stopDrag(); }
        
        //最小化ボタン
        private function createMinimizeButton():PushButton {
            var result:PushButton = new PushButton(null, 215, 3, "-", minimize);
            result.width = result.height = 14; result.draw();
            return result;
        }
        
        //ウィンドウ
        private function createWindow(messageDisplayHeight:int):Sprite {
            var result:Sprite = new Sprite();
            result.y = 20;
            result.graphics.lineStyle(0,color1);
            result.graphics.beginFill(0x000033, 0.1);
            result.graphics.drawRect(0, 0, 232, messageDisplayHeight + 20);
            result.graphics.endFill();
            
            result.mouseEnabled = true;
            result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
            result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);

            return result;
        }
        
        //メッセージ欄
        private function createMessageDisplay(logSize:int):TextField {
            var result:TextField = new TextField();
            result.width = 232;
            result.defaultTextFormat = new TextFormat("_sans", 12, color1);
            //result.filters = [new DropShadowFilter(0, 0, 0x000055, 3,3,2,2)];
            result.mouseEnabled = result.selectable = false;
            result.wordWrap = true;
            for (var i:int = 0; i < logSize; i++) { result.appendText(i + "\n"); }
            result.height = result.textHeight + 4; result.text = "";
            return result;
        }
        //入力ボックス
        private function createInputText(x:int, y:int, width:int, maxChars:int, text:String):TextField {
            var result:TextField = new TextField();
            result.x = x; result.y = y;
            result.width = width; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, color1);
            //result.background = true; result.backgroundColor = 0x0033aa;
            result.border = true;result.borderColor=color1;
            //result.filters = [new BevelFilter(1, 225, 0xC0C0C0, 1, 0x404040, 1, 1, 1)];
            result.maxChars = maxChars;
            result.selectable = true;
            result.type = TextFieldType.INPUT;
            result.text = text;
            return result;
        }
        
        private function createSayLabel(y:int):TextField {
            var result:TextField = new TextField();
            result.x = 1; result.y = y;
            result.width = 30; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, color1, null, null, null, null, null, TextFormatAlign.CENTER);
            //result.filters = [new GlowFilter(0x000000, 1, 2, 2)];
            result.mouseEnabled = result.selectable = false;
            result.text = "発言:";
            return result;
        }
        
        private function addedToStageHandler(event:Event):void {
            _reactor.addEventListener(ReactorEvent.READY, joinRoom);
            _reactor.addEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (_isReactorShared) {
                if (_reactor.isReady()) { joinRoom(); }
            } else {
                _reactor.getConnectionMonitor().setAutoReconnectFrequency(5000);
                _reactor.getLog().setLevel(Logger.FATAL);
                _reactor.connect("ozworks.dip.jp", 9100);
            }
        }
        
        private function removedFromStageHandler(event:Event):void {
            _reactor.removeEventListener(ReactorEvent.READY, joinRoom);
            _reactor.removeEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (!_isReactorShared) { _reactor.disconnect(); }
        }
        
        private function joinRoom(event:ReactorEvent = null):void {
            var updateLevels:UpdateLevels = new UpdateLevels();
            updateLevels.clearAll();
            updateLevels.occupantCount = updateLevels.roomMessages = true;
            
            _room = _reactor.getRoomManager().createRoom(_roomID);
            roomOccupantCountHandler();
            _room.addEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
            _room.addMessageListener("CHAT_MESSAGE", receiveMessage);
            _room.join(null, updateLevels);
            
        }
        
        private function roomOccupantCountHandler(event:RoomEvent = null):void {
            _statusBar.text = _title + " " + _room.getNumOccupants() + "人";
            alart1();
        }
        
        private function leaveRoom(event:ReactorEvent = null):void {
            if (_room) {
                _room.removeEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
                _room.removeMessageListener("CHAT_MESSAGE", receiveMessage);
                _room.leave();
            }
            
            _statusBar.text = "サーバーに接続中...";
        }
        
        //メッセージ送信
        private function sendMessage(event:KeyboardEvent):void {
            
            var now:Date = new Date();
            updateTime = now.getTime();
            
            if (!_reactor.isReady() || event.keyCode != Keyboard.ENTER || _messageInput.text == "") { return; }
            _room.sendMessage("CHAT_MESSAGE", true, null, _nameInput.text, _messageInput.text);
            _so.data.name = _nameInput.text;
            _messageInput.text = "";
        }
        
        //メッセージ受信
        private function receiveMessage(from:IClient, senderName:String, messageText:String):void {
            _messages.push(senderName + ": " + messageText);
            if (_messages.length > _messageLogSize) { _messages.shift(); }
            
            _messageDisplay.text = "";
            var messagesLength:int = _messages.length;
            for (var i:int = 0; i < messagesLength; i++) {
                _messageDisplay.appendText(_messages[i] + "\n");
            }
            
            alart1();
        }
        
        public function minimize(event:MouseEvent = null):void {
            _window.visible = !_window.visible;
            if (_minimizeButton) { _minimizeButton.label = (_window.visible) ? "-" : "+"; }
        }
        
        
        private function alart1():void{
            var now:Date = new Date();
            if(updateTime+1000*120 < now.getTime()){
                playSnd("http://ozworks.dip.jp/sound/l.mp3");
                updateTime = now.getTime();
            }
        }

        private var updateTime:Number;
        private var sndList:Array = new Array();
        private function playSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
            }
            sndList[url].play();
        }
    }
//}