/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nSuE
 */

// forked from fakestar0826's RunnningInTrees
package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var trees:Array;
        private var numTrees:uint = 100;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        private var floor:Number = 50;
        private var ax:Number = 0;
        private var ay:Number = 0;
        private var az:Number = 0;
        private var vx:Number = 0;
        private var vy:Number = 0;
        private var vz:Number = 0;
        private var gravity:Number = 0.3;
        private var friction:Number = 0.98;
        
        public function FlashTest() {
            // write as3 code here..
            trees = [];
            for(var i:int = 0;i < numTrees;i++)
            {
                var t:Tree = new Tree();
                trees[i] = t;
                t.xpos = Math.random() * 2000 - 1000;
                t.ypos = floor;
                t.zpos = Math.random() * 10000;
                addChild(t);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onEnterFrame(e:Event):void
        {
            vx += ax;
            vy += ay;
            vz += az;
            vy -= gravity;
            for(var i:int = 0;i < numTrees;i++)
            {
                var t:Tree = trees[i];
                move(t);
            }
            vx *= friction;
            vy *= friction;
            vz *= friction;
            sortZ();
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.UP:
                az = -1;
                break;
                case Keyboard.DOWN:
                az = 1;
                break;
                case Keyboard.LEFT:
                ax = 1;
                break;
                case Keyboard.RIGHT:
                ax = -1;
                break;
                case Keyboard.SPACE:
                ay = 1;
                break;
                default:
                break;
            }

        }
        
        private function onKeyUp(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.UP:
                case Keyboard.DOWN:
                az = 0;
                break;
                case Keyboard.LEFT:
                case Keyboard.RIGHT:
                ax = 0;
                break;
                case Keyboard.SPACE:
                ay = 0;
                break;
                default:
                break;
            }

        }

        private function move(t:Tree):void
        {
            t.xpos += vx;
            t.ypos += vy;
            t.zpos += vz;
            
            if(t.ypos < floor)
            {
                t.ypos = floor;
            }

            if(t.zpos < -fl)
            {
                t.zpos += 1000;
            }
            if(t.zpos > 10000 - fl)
            {
                t.zpos -= 10000;
            }
            
            var scale:Number = fl / (fl + t.zpos);
            t.scaleX = t.scaleY = scale;
            t.x = vpX + t.xpos * scale;
            t.y = vpY + t.ypos * scale;
            t.alpha = scale;
        }
        
        private function sortZ():void
        {
            trees.sortOn("zpos", Array.NUMERIC | Array.DESCENDING);
            for(var i:int = 0;i < numTrees;i++)
            {
                var t:Tree = trees[i];
                setChildIndex(t, i);
            }

        }

    }
}
import flash.display.Sprite;

class Tree extends Sprite
{
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    
    public function Tree()
    {
        graphics.lineStyle(0, 0);
        graphics.lineTo(0, -140 - Math.random() * 20);
        graphics.moveTo(0, -30 - Math.random() * 30);
        graphics.lineTo(Math.random() * 80 - 40, -100 - Math.random() * 40);
        graphics.moveTo(0, -60 - Math.random() * 40);
        graphics.lineTo(Math.random() * 60 - 30, -110 - Math.random() * 20);
    }

}
