/**
 * Copyright i.Nert ( http://wonderfl.net/user/i.Nert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nRpkh
 */

/* Aim: To load an MD2 mesh from a server (WIP) */

package {
    import flash.display.AVM1Movie;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.Security;
    
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.cameras.DebugCamera3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.parsers.MD2;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.events.FileLoadEvent;
    
    [SWF(width=640, height=480, frameRate=30)]
    
    public class PV3DTest extends Sprite {
        
        //Scene variables
        private var view:Viewport3D = new Viewport3D();
        private var scene:Scene3D = new Scene3D();
        private var cam:DebugCamera3D = new DebugCamera3D(view, 45);
        private var renderer:BasicRenderEngine = new BasicRenderEngine();
        
        private static const secPol:String = "BLANK";
        
        //MD2 variables
        private static const URL_testMesh:String = "BLANK"
        private var UL_testMesh:URLLoader = new URLLoader();
        private var MD2_testMesh:MD2 = new MD2(false);
        
        //Material varibles
        private var wmat:WireframeMaterial = new WireframeMaterial(0x000000, 100, 2);
        
        public function PV3DTest() {
            Security.loadPolicyFile(secPol);
            
            cam.z = -400;
            
            //loadMeshes();
            createScene();
            
            addChild(view);
            this.addEventListener(Event.ENTER_FRAME, renderScene);  
        }
        
        private function loadMeshes():void {
            /*UL_testMesh.dataFormat = URLLoaderDataFormat.BINARY;
            UL_testMeshaddEventListener(FileLoadEvent.LOAD_COMPLETE, createScene);
            UL_testMesh.addEventListener(FileLoadEvent.LOAD_ERROR, createScene);
            UL_testMeshaddEventListener(FileLoadEvent.SECURITY_LOAD_ERROR, createScene);
            UL_testMesh.load(new URLRequest(URL_chemgirl));*/
            MD2_testMesh.load(UL_testMesh, wmat, 6, 4);
            MD2_testMesh.addEventListener(FileLoadEvent.LOAD_COMPLETE, createScene);
            //createScene();
        }

        private function createScene(/*e:FileLoadEvent*/):void {
            var sphere1:Sphere = new Sphere(wmat, 40);
            scene.addChild(sphere1);
            scene.addChild(MD2_testMesh);
        }
        
        private function renderScene(e:Event):void {
            renderer.renderScene(scene, cam, view);
        }

    }
}