/**
 * Copyright toburau ( http://wonderfl.net/user/toburau )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nRTy
 */

// Blind
// 元ネタはWii Fit Plusのミニゲームの一つ。
// 画面下の赤い四角を左右のカーソルキーで操作して
// 上から降りてくる障害物を避ける。
// だんだんと中央部分を隠すブラインドが大きくなっていくので、
// 障害物の動きを予測しながら避ける。
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;

     [SWF(backgroundColor="0x000000")]

    public class Project11 extends Sprite {
        private var mode:int = 0;
       
         public function Project11() {
            Key.init(stage);
            s_messageField = createTextField(0,0,stage.stageWidth,36,0x66ff66);
             init();
         }
       
         public function init():void {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;

            s_ScreenWidth = stage.stageWidth;
            s_ScreenHeight = stage.stageHeight;

            s_StageLeft = 80;
            s_StageRight = stage.stageWidth - 80;
           
            addEventListener(Event.ENTER_FRAME, onEnterFrame);

            s_Bg.init();
            addChild(s_Bg);
           
            s_Player.init();
             addChild(s_Player);

            for(var i:int=0; i<WALLMAX; i++) {
                var wall:Wall = new Wall();
                wall.init();
                s_WallList.push(wall);
                addChild(wall);
            }

            s_Blind.init();
            addChild(s_Blind);

            s_WallIndex = 0;
            mode = 0;

            addChild(s_messageField);

            s_Count = WALLINTERVAL;
        }

        public function reset():void {
            s_Player.init();
            for(var i:int=0; i<WALLMAX; i++) {
                s_WallList[i].init();
            }
            s_WallIndex = 0;
            s_Count = WALLINTERVAL;
        }
       
        public function onEnterFrame(e:Event):void {

            s_Bg.Proc();
            s_Blind.Proc();

            if(mode == 0) {
                // Title
                setText(180,120,"Blind");
                if(Key.isPush(Key.SPACE)) {
                    setText(20,120,"Push SPACE to Start");
                    mode = 1;
                }
            } else if(mode == 1) {
                // Ready
                if(Key.isPush(Key.SPACE)) {
                    setText(0,0,"");
                    mode = 2;
                    s_isHit = false;
                }
            } else if(mode == 2) {
                // inGame
                 s_Player.Proc();
                for(var i:int=0; i<WALLMAX; i++) {
                    s_WallList[i].Proc();
                }
                s_Count++;
                if(s_Count >= WALLINTERVAL) {
                    if(!s_WallList[s_WallIndex].isActive) {
                        s_WallList[s_WallIndex].start();
                        s_WallIndex++;
                        if(s_WallIndex >= WALLMAX) {
                            s_WallIndex = 0;
                        }
                        s_Count = 0;
                    }   
                }
                if(s_isHit) {
                    setText(140,140,"Game Over");
                    mode = 3;
                }
            } else if(mode == 3) {
                // GameOver
                if(Key.isPush(Key.SPACE)) {
                    reset();
                    setText(20,120,"Push SPACE to Start");
                    s_Blind.init();
                    for(i=0; i<WALLMAX; i++) {
                        s_WallList[i].init();
                    }
                    mode = 1;
                }
            }
           
            Key.update();
         }
    }
}

// キーボードからの入力をチェックするクラスKey
// 使用法：
// 起動時にinit()で初期化する。引数はstage。
//     Key.init(stage);
// フレーム更新処理中キー入力の判定が終わったあとにupdate()を呼び出す。
//     Key.update();
// isPress(keycode)で押されているか取得。
// isPush(keycode)で押されていない状態から押されたときを取得
// 引数に渡すkeycodeは次のとおり。
//    UP カーソル上
//  DOWN カーソル下
//  LEFT カーソル左
// RIGHT カーソル右
// SPACE スペースキー
// ENTER Enterキー
//
// 使用例
// 　　onFrameUpdate() {
//        if( Key.isPress(Key.UP) ) {
//            // カーソル上が押されているときの処理
//        }
//        ...
//        Key.update(); // キーの判定が終わったらupdate()を呼ぶ
//    }
//
import flash.display.InteractiveObject;
import flash.events.KeyboardEvent;
import flash.events.FocusEvent;
import flash.events.Event;
import flash.ui.Keyboard;

class Key
{
    public static const    UP:uint = 0;
    public static const  DOWN:uint = 1;
    public static const  LEFT:uint = 2;
    public static const RIGHT:uint = 3;
    public static const SPACE:uint = 4;
    public static const ENTER:uint = 5;
    private static const CODEMAX:uint = 6;

    private static var m_Press:Vector.<Boolean> = new Vector.<Boolean>(CODEMAX);
    private static var m_Push:Vector.<Boolean> = new Vector.<Boolean>(CODEMAX);
   
    public static function init(target:InteractiveObject):void {
        target.stage.focus = target;
        for(var i:int=0; i<CODEMAX; i++) {
            m_Press[i] = false;
            m_Push[i] = false;
        }
       
        target.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        target.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
    }
    public static function update():void {
        for(var i:int=0; i<CODEMAX; i++) {
            m_Push[i] = false;
        }
    }
   
    public static function isPress(keycode:uint):Boolean {
        return m_Press[keycode];
    }
    public static function isPush(keycode:uint):Boolean {
        return m_Push[keycode];
    }

    private static function onKeyDown(event:KeyboardEvent):void {
        switch(event.keyCode) {
            case Keyboard.UP:
            if(m_Press[UP] == false) {
                m_Push[UP] = true;
            }
            m_Press[UP] = true;
            break;
            case Keyboard.DOWN:
            if(m_Press[DOWN] == false) {
                m_Push[DOWN] = true;
            }
            m_Press[DOWN] = true;
            break;
            case Keyboard.LEFT:
            if(m_Press[LEFT] == false) {
                m_Push[LEFT] = true;
            }
            m_Press[LEFT] = true;
            break;
            case Keyboard.RIGHT:
            if(m_Press[RIGHT] == false) {
                m_Push[RIGHT] = true;
            }
            m_Press[RIGHT] = true;
            break;
            case Keyboard.SPACE:
            if(m_Press[SPACE] == false) {
                m_Push[SPACE] = true;
            }
            m_Press[SPACE] = true;
            break;
            case Keyboard.ENTER:
            if(m_Press[ENTER] == false) {
                m_Push[ENTER] = true;
            }
            m_Press[ENTER] = true;
            break;
            default:
            break;
        }
    }
    private static function onKeyUp(event:KeyboardEvent):void {
        switch(event.keyCode) {
            case Keyboard.UP:
            m_Press[UP] = false;
            break;
            case Keyboard.DOWN:
            m_Press[DOWN] = false;
            break;
            case Keyboard.LEFT:
            m_Press[LEFT] = false;
            break;
            case Keyboard.RIGHT:
            m_Press[RIGHT] = false;
            break;
            case Keyboard.SPACE:
            m_Press[SPACE] = false;
            break;
            case Keyboard.ENTER:
            m_Press[ENTER] = false;
            break;
            default:
            break;
        }
    }
}

//
//
//
import flash.display.Sprite;
import flash.display.Graphics;
import flash.filters.GlowFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

var s_messageField:TextField;
function createTextField(x:int, y:int, width:int, size:int, color:int,
                         align:String = TextFormatAlign.LEFT):TextField
{
    var fm:TextFormat = new TextFormat;
    fm.font = "_typewriter"; fm.bold = true;
    fm.size = size; fm.color = color;
    fm.align = align;
    var fi:TextField = new TextField;
    fi.defaultTextFormat = fm;
    fi.x = x; fi.y = y; fi.width = width;
    fi.selectable = false;
    return fi;
}

function setText(x:int, y:int, str:String):void
{
    s_messageField.x = x;
    s_messageField.y = y;
    s_messageField.text = str;
}

const WALLMAX:int = 4;
const SCROLLSPEED:int = 3;
const WALLINTERVAL:int = 50;

var s_ScreenWidth:int;
var s_ScreenHeight:int;
var s_Count:int;

var s_StageLeft:int;
var s_StageRight:int;

var s_WallList:Array = new Array();
var s_WallIndex:int = 0;

var s_isHit:Boolean = false;

class Wall extends Sprite {
    private const SIZE:int = 50;
    private var speed:int = 0;
    public var isActive:Boolean = false;
   
    public function Wall() {
        graphics.beginFill(0x99ddbb);
        graphics.drawRoundRect(0, 0, SIZE, SIZE, 10);
        graphics.endFill();
        filters = [new GlowFilter(0x00ff00,1,16,16,1,1,false,false)];
    }

    public function init():void {
        y = -SIZE;
        isActive = false;
        visible = false;
    }

    public function start():void {
        speed = Math.round(Math.random()*4)+1;
        if( (Math.random()*100) > 50 ) { speed *= -1; }
        x = Math.round(Math.random()*(s_StageRight-s_StageLeft-SIZE)+s_StageLeft);
        y = -SIZE;
        isActive = true;
        visible = true;
    }

    public function Proc():void {
        if(isActive) {
            x += speed;
            if( x < s_StageLeft ) {
                x = s_StageLeft;
                speed *= -1;
            }
            else if( x > s_StageRight - SIZE) {
                x = s_StageRight - SIZE;
                speed *= -1;
            }
            y += SCROLLSPEED;
            if( y > s_ScreenHeight ) {
                isActive = false;
                visible = false;
                s_Blind.SetSize(20);
            }

            if( (y+SIZE) > s_Player.y && y < s_Player.y + s_Player.SIZE) {
                if( x < s_Player.x+s_Player.SIZE && x+SIZE > s_Player.x ) {
                    // Hit!
                    s_isHit = true;
                }
            }
        }
    }
}

var s_Player:Player = new Player;
class Player extends Sprite {
    public const SIZE:int = 20;
    private const SPEED:int = 5;

    public function Player() {
        graphics.beginFill(0xaa1111);
        graphics.drawRoundRect(
            0, 0,
            SIZE,SIZE,
            10);
        graphics.endFill();
        filters = [new GlowFilter(0xff0000,1,16,16,1,1,false,false)];
    }

    public function init():void {
        x = (s_StageRight-s_StageLeft)/2 + s_StageLeft - SIZE/2;
        y = s_ScreenHeight - SIZE - SIZE/2;
    }

    public function Proc():void {
        if(Key.isPress(Key.LEFT))
        {
            x-=SPEED;
            if(x < s_StageLeft) x = s_StageLeft;
        }
        if(Key.isPress(Key.RIGHT))
        {
            x+=SPEED;
            if(x > s_StageRight-SIZE) x = s_StageRight-SIZE;
        }
    }
}

var s_Bg:Bg = new Bg;
class Bg extends Sprite {
    private const NUM:int = 5;

    public function Bg() {
    }

    public function init():void {
        graphics.lineStyle(2,0x4455bb);
        graphics.moveTo(s_StageLeft, -s_ScreenHeight/NUM);
        graphics.lineTo(s_StageLeft, s_ScreenHeight);
        graphics.moveTo(s_StageRight, -s_ScreenHeight/NUM);
        graphics.lineTo(s_StageRight, s_ScreenHeight);
        for(var i:int=0; i<NUM; i++) {
            graphics.moveTo(s_StageLeft,i*(s_ScreenHeight/NUM));
            graphics.lineTo(s_StageRight,i*(s_ScreenHeight/NUM));
        }
        filters = [new GlowFilter(0x0000ff,1,16,16,3,1,false,false)];
        x = 0;
        y = 0;
    }
    public function Proc():void {
        y += SCROLLSPEED;
        if(y >= s_ScreenHeight/NUM) { y = 0; }
    }
}

var s_Blind:Blind = new Blind;
class Blind extends Sprite {
    private var curSize:int = 0;
    private var toSize:int = 0;
    public function Blind() {
    }
    public function init():void {
        graphics.clear();
        curSize = 0;
        toSize = 0;
    }
    public function SetSize(s:int):void {
        toSize += s;
        if(toSize > 310) { toSize = 310; }
    }
    public function Proc():void {
        if(curSize < toSize) { curSize++; }
        if(curSize>0) {
            graphics.clear();
            graphics.beginFill(0x99bbff);
            graphics.drawRoundRect(s_StageLeft-10, s_ScreenHeight/2-curSize/2, s_StageRight-s_StageLeft+20, curSize, 10);
            graphics.endFill();
            filters = [new GlowFilter(0x0000ff,1,16,16,1,1,false,false)];
        }
    }
}

