/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nRO5
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.getTimer;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	public class TestMatrix extends Sprite
	{
		private var currentBall:Sprite;
		private var balls:Vector.<Sprite> = new Vector.<Sprite>;
		private var bmd:BitmapData;
		private var uv:Matrix;
		public function TestMatrix() 
		{
			var tf:TextField = new TextField;
			tf.autoSize = "left";
			tf.defaultTextFormat = new TextFormat(null, 100);
			tf.text = "AB";
			tf.textColor = 0xffffff;
			bmd = new BitmapData(tf.width, tf.height, false, 0);
			var bmp:Bitmap = new Bitmap(bmd);
			bmd.draw(tf);
			
			stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
			for (var i:int = 0; i < 4;i++ ) {
				var ball:Sprite = createBall(i);
				addChild(ball);
				ball.x = 400 * Math.random();
				ball.y = 400 * Math.random();
				balls.push(ball);
			}
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void 
		{
			graphics.clear();
			drawByUV(.5, 0, 1, 1, .5, 1, balls[0].x, balls[0].y, balls[2].x, balls[2].y, balls[1].x, balls[1].y);
			drawByUV(.5, 0, 1, 1, 1, 0, balls[0].x, balls[0].y, balls[2].x, balls[2].y, balls[3].x, balls[3].y);
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
		}
		//http://www.rubenswieringa.com/code/as3/flex/DistortImage/source/
		private function drawByUV(u0:Number, v0:Number, u1:Number, v1:Number, u2:Number, v2:Number, x0:Number, y0:Number, x1:Number, y1:Number, x2:Number, y2:Number):void {
			var _sMat:Matrix = new Matrix();
            var _tMat:Matrix = new Matrix();
			var _w:Number =  bmd.width;
			var _h:Number =  bmd.height;
			u0 *= _w;
			u1 *= _w;
			u2 *= _w;
			v0 *= _h;
			v1 *= _h;
			v2 *= _h;
			_tMat.tx = u0;
			_tMat.ty = v0;
			_tMat.a = ( u1 - u0 ) / _w;
			_tMat.b = ( v1 - v0 ) / _w;
			_tMat.c = ( u2 - u0 ) / _h;
			_tMat.d = ( v2 - v0 ) / _h;
			_sMat.a = ( x1 - x0 ) / _w;
			_sMat.b = ( y1 - y0 ) / _w;
			_sMat.c = ( x2 - x0 ) / _h;
			_sMat.d = ( y2 - y0 ) / _h;
			_sMat.tx = x0;
			_sMat.ty = y0;
			_tMat.invert();
			_tMat.concat( _sMat );
			graphics.beginBitmapFill(bmd,_tMat,true,true);
			graphics.moveTo(x0, y0);
			graphics.lineTo(x1, y1);
			graphics.lineTo(x2, y2);
			graphics.lineTo(x0, y0);
		}
		
		private function mouseMove(e:MouseEvent):void 
		{
			enterFrame(null);
			e.updateAfterEvent();
		}
		
		private function createBall(i:int):Sprite {
			var b:Sprite = new Sprite;
			var tf:TextField = new TextField;
			tf.mouseEnabled = tf.mouseWheelEnabled = false;
			b.addChild(tf);
			tf.autoSize = "left";
			tf.text = "" + i;
			tf.x = -tf.width / 2;
			tf.y = -tf.height / 2;
			b.graphics.beginFill(0xffffff * Math.random(), .7);
			b.graphics.drawCircle(0, 0, 10);
			b.addEventListener(MouseEvent.MOUSE_DOWN, onMD);
			addChild(b);
			return b;
		}
		
		private function onMD(e:Event):void {
			currentBall = e.currentTarget as Sprite;
			currentBall.filters = [new GlowFilter];
			currentBall.startDrag();
		}
		
		private function stage_mouseUp(e:MouseEvent):void 
		{
			stopDrag();
			if (currentBall) {
				currentBall.filters = [];
				currentBall = null;
			}
		}
		
	}

}