/**
 * Copyright alexnotkin ( http://wonderfl.net/user/alexnotkin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nRIy
 */

package  {
    // Source Code with 3 balls was found 
    // here http://applesaucejuice.net/2008/12/metaballs-as3/
    // author - scy
 
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Point;
 
    public class Main extends Sprite {
 
        private var output:BitmapData;
        private var buffer:BitmapData;
        private var aPoint:Point;
        private var threshold:Number;
        private var b1_x:int;
        private var b1_y:int;
        private var b1_x_vel:int;
        private var b1_y_vel:int;
        private var b2_x:int;
        private var b2_y:int;
        private var b2_x_vel:int;
        private var b2_y_vel:int;
        private var b3_x:int;
        private var b3_y:int;
        private var b3_x_vel:int;
        private var b3_y_vel:int;
        private var b4_x:int;
        private var b4_y:int;
        private var b4_x_vel:int;
        private var b4_y_vel:int;
 
 
        public function Main() {
            buffer = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            output = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            aPoint = new Point(0, 0);
            threshold = 1 / 35 
            ;
            b1_x = 60;
            b1_y = 60;
            b1_x_vel = 4;
            b1_y_vel = 2;
            
            b2_x = 90;
            b2_y = 180;
            b2_x_vel = 4;
            b2_y_vel = 6;
            
            b3_x = 100;
            b3_y = 100;
            b3_x_vel = 5;
            b3_y_vel = -3;
            
            b4_x = 300;
            b4_y = 300;
            b4_x_vel = 10;
            b4_y_vel = -8;
 
            addChild(new Bitmap(output));
            stage.addEventListener(Event.ENTER_FRAME, render);
        }
 
        private function render( e:Event ):void {
            // Apply velocity and check boundaries
            b1_x += b1_x_vel; if ( b1_x > stage.stageWidth || b1_x < 0 ) { b1_x_vel *= -1; }
            b1_y += b1_y_vel; if ( b1_y > stage.stageHeight || b1_y < 0 ) { b1_y_vel *= -1; }
            b2_x += b2_x_vel; if ( b2_x > stage.stageWidth || b2_x < 0 ) { b2_x_vel *= -1; }
            b2_y += b2_y_vel; if ( b2_y > stage.stageHeight || b2_y < 0 ) { b2_y_vel *= -1; }
            b3_x += b3_x_vel; if ( b3_x > stage.stageWidth || b3_x < 0 ) { b3_x_vel *= -1; }
            b3_y += b3_y_vel; if ( b3_y > stage.stageHeight || b3_y < 0 ) { b3_y_vel *= -1; }
            b4_x += b4_x_vel; if ( b4_x > stage.stageWidth || b4_x < 0 ) { b4_x_vel *= -1; }
            b4_y += b4_y_vel; if ( b4_y > stage.stageHeight || b4_y < 0 ) { b4_y_vel *= -1; } 
 
            // Apply metaball formula : 1 / sqrt( (x1-x0)^2 + (y1-y0)^2 )
            for ( var i:int = 0; i < buffer.width; i++ ) {
                for ( var j:int = 0; j < buffer.height; j++ ) 
         {
                    var ball_1:Number = 1 / Math.sqrt( ((i - b1_x) * (i - b1_x)) + ((j - b1_y) * (j - b1_y)) );
                    var ball_2:Number = 1 / Math.sqrt( ((i - b2_x) * (i - b2_x)) + ((j - b2_y) * (j - b2_y)) );
                    var ball_3:Number = 1 / Math.sqrt( ((i - b3_x) * (i - b3_x)) + ((j - b3_y) * (j - b3_y)) );
                   var ball_4:Number = 1 / Math.sqrt( ((i - b4_x) * (i - b4_x)) + ((j - b4_y) * (j - b4_y)) ); 
                    if ( ball_1 + ball_2 + ball_3 +ball_4> threshold ) {
                        buffer.setPixel(i, j, 0x000000);
                    }
                    else {
                        buffer.setPixel(i, j, 0xFFFFFF);
                    }
                }
            }
 
            output.copyPixels(buffer, buffer.rect, aPoint);
        }
    }
}