/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nRGJ
 */

// forked from Glav's Split movieClips
package {
    import flash.display.Sprite;
    
    import flash.display.Graphics;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor="#333333", width="465", height="465", frameRate="60")]
    
    public class FlashTest extends Sprite {
        public static const SQ_WIDTH:int = 20;
        public static const SQ_HEIGHT:int = 20;
        
        private var _bmp:Bitmap;
        private var _bmpData:BitmapData;
        
        private var _fsqs:Vector.<Piece>;
        
        public const SCREEN_WIDTH:Number = 465;
        public const SCREEN_HEIGHT:Number = 465;
        
        private var mytext:TextField = new TextField;
        
        public function FlashTest() {
            // draw stuff here
            
            // a cirlce
            graphics.beginFill(0xDD5555);
            graphics.drawCircle(150,150,100);
            graphics.endFill();
            
            // a square
            graphics.beginFill(0x55DD55);
            graphics.drawRect(300, 100, 100, 100);
            graphics.endFill();
            
            // a text
            with (addChild(mytext)) {
                text = "Move you mouse !";
                selectable = false;
                width = SCREEN_WIDTH;
                y = 330;
                setTextFormat(new TextFormat("Arial",46,0x55AADD, true, null, null, null, null, "center"));
            }
            
            setup();
        }
        
        private function setup():void {
            _bmpData = new BitmapData(SCREEN_WIDTH, SCREEN_HEIGHT, true, 0x00ffffff);
            _bmpData.draw(this.stage);
            
            _fsqs = new Vector.<Piece>();
            
            var numRows:int = Math.ceil( SCREEN_HEIGHT / SQ_HEIGHT );
            var numCols:int = Math.ceil( SCREEN_WIDTH / SQ_WIDTH );
            
            var _tempBmp:Bitmap;
            var xLoc:Number, yLoc:Number;
            for (var i:int = 0; i < numCols; i++) {
                for (var j:int = 0; j < numRows; j++) {
                    xLoc = (i * SQ_WIDTH);
                    yLoc = j * SQ_HEIGHT;
                    var rect:Rectangle = new Rectangle( xLoc, yLoc, SQ_WIDTH, SQ_HEIGHT );
                    var _tempBmd:BitmapData = new BitmapData(SQ_WIDTH, SQ_HEIGHT, true, 0x00ffffff);
                    _tempBmd.copyPixels(_bmpData, rect, new Point());
                    _tempBmp = new Bitmap(_tempBmd, 'auto', false);
                    _tempBmp.x = - (SQ_WIDTH / 2);
                    _tempBmp.y = -(SQ_HEIGHT / 2);
                    
                    var tarLocX:Number = xLoc + (SQ_WIDTH / 2);
                    var tarLocY:Number = yLoc + (SQ_HEIGHT / 2);
                    
                    var maskColor:uint = 0xFFFFFF;
                    var color:uint = 0xFF0000;
                    
                    var testRec:Rectangle = _tempBmd.getColorBoundsRect(0x00ffffff, 0x00333333, false);
                    
                    if (testRec.width > 0 && testRec.height > 0 && testRec ) {
                        var fsq:Piece = new Piece(_tempBmp, tarLocX, tarLocY );
                        fsq.setTarLoc(tarLocX, tarLocY);
                        _fsqs.push( fsq );
                    }
                }
            }
            
            mytext.visible = false // because text doesn't disappear like a shape
            
            for (i = 0; i < _fsqs.length; i++) {
                
                addChild( _fsqs[i] );
            }
            
            stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                graphics.clear();
                var d:Number = 0;
                var a:Number = 0;
                
                for (var i:int = 0; i < _fsqs.length; i++) {
                    var fsq:Piece = _fsqs[i];
                    d = fsq.getdist;
                    d = d > 150 ? 150 :d;
                    a = d / 150;
                    if(a > 0) a += .2;
                    if (a > 1) a = 1;
                    graphics.lineStyle(1, 0xffffff, a * 1);
                    graphics.moveTo(fsq.x, fsq.y);
                    graphics.curveTo(fsq.ctlPt.x, fsq.ctlPt.y, fsq.tarLoc.x, fsq.tarLoc.y);
                }
                
                for (i = 0; i < _fsqs.length; i++) {
                    _fsqs[i].addForce(mouseX, mouseY, 0, 100, -2);
                    _fsqs[i].seekHome(.006);
                    _fsqs[i].addDamping(.09);
                    _fsqs[i].update();
                }
            });
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
                for (i = 0; i < _fsqs.length; i++) {
                    _fsqs[i].addForce(mouseX, mouseY, 0, 100, -200);
                    _fsqs[i].update();
                }
            });
        }
    }
}

import flash.display.Bitmap;
import flash.display.Sprite;
import flash.geom.Vector3D;

class Piece extends Sprite {
    private static const MAX_SPEED:Number = 5;
    
    private var _loc:Vector3D = new Vector3D();
    private var _vel:Vector3D = new Vector3D();
    private var _acc:Vector3D = new Vector3D();
    private var _ctlVel:Vector3D = new Vector3D();
    
    public var tarLoc:Vector3D = new Vector3D();
    public var ctlPt:Vector3D = new Vector3D();
    public var getdist:Number = 0;
    
    public function Piece(sourceBmd:Bitmap, x:Number = 0, y:Number = 0) {
        addChild(sourceBmd);
        _loc.x = x = x;
        _loc.y = y = y;
        ctlPt.x = x;
        ctlPt.y = y;
    }
    
    public function update():void {
        var dist:Vector3D = tarLoc.subtract( _loc );
        getdist = dist.length;
        
        _vel = _vel.add( _acc );
        
        _loc = _loc.add( _vel );
        
        springCtrlPt( .02 );
        _ctlVel.scaleBy( .97 );
        ctlPt = ctlPt.add( _ctlVel );
        
        x = _loc.x;
        y = _loc.y;
        
        _acc.x = _acc.y = _acc.z = 0;
    }
    
    public function addForce(x:Number, y:Number, z:Number, minDist:Number, scale:Number):void {
        var tarLoc:Vector3D = new Vector3D(x, y, z);
        var dir:Vector3D = tarLoc.subtract(_loc);
        var d:Number = dir.length;
        
        if (d > 0) {
            if (d < minDist) {
                var pct:Number = 1 - (d / minDist);
                dir.normalize();
                dir.scaleBy(scale * pct);
                _acc = _acc.add( dir );
            }
        }
    }
    
    public function addDamping(damp:Number = .08):void {
        var dir:Vector3D = _acc.subtract( _vel );
        dir.scaleBy( damp );
        _acc = _acc.add( dir );
    }
    
    public function seekHome(scale:Number = .01):void {
        var dir:Vector3D = tarLoc.subtract( _loc );
        
        dir.scaleBy( scale );
        
        _acc = _acc.add( dir );
    }
    
    public function setTarLoc(x:Number, y:Number, z:Number = 0):void {
        tarLoc.x = x; tarLoc.y = y; tarLoc.z = z;
    }
    
    public function springCtrlPt(scale:Number):void {
        var dest:Vector3D = _loc.subtract( tarLoc );
        
        dest.scaleBy( .5 );
        dest = dest.add( tarLoc );
        
        if (dest.length > 0) {
            var tar:Vector3D = dest.subtract( ctlPt );
            tar.scaleBy( scale );
            var gravity:Vector3D = new Vector3D(0, .4, 0);
            tar = tar.add( gravity );
            _ctlVel = _ctlVel.add( tar );
        }
    }
}