/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nR9R
 */

// forked from whirlpower's forked from: Tiling
// forked from quqjp's Tiling
package 
{
    /*
    * BitmapをやめてShapeにしてみた。
    * 構造理解のため、そぎ落とせるところはそぎ落としている。
    *
    * ※ 止まりません。
    */

    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import frocessing.color.ColorHSV;
    public class Tiling extends Sprite
    {
        static public const TILE_SCALE:int = 15;
        private var mapLogic:MapLogic;
        private static var debugger:Debugger;
        private var csprite:Sprite;
        private var continueButton:PushButton;
        private var colorHSV:ColorHSV;
        private var counter:uint;
        private var tileAmount:int;
        private var psprite:Sprite;
        private var stopButton:PushButton;
        private var isStopped:Boolean;
        private var playButton:PushButton;
        private var stepButton:PushButton;
        
        public function Tiling():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            debugger = new Debugger(this);
            stage.frameRate = 5;
            tileAmount = int(465 / TILE_SCALE);
            mapLogic = new MapLogic( tileAmount, tileAmount, 10, TILE_SCALE );
            mapLogic.mapSignal.add(drawMap);
            //mapLogic.lineSignal.add(onLineSignal);
            mapLogic.positionSignal.add(onPositionSignalHandler);
            mapLogic.emptyWidthSignal.add(onEmptyWidthSignalHandler);
            mapLogic.lengthChange.add(onMapChange);
            csprite = Sprite(addChild(new Sprite));
            addEventListener( Event.ENTER_FRAME, render );
            continueButton = new PushButton(this, 465, 500, 'continue', doContinue);
            stopButton = new PushButton(this, 565, 500, 'stop', doStop);
            playButton = new PushButton(this, 665, 500, 'play', doPlay);
            stepButton = new PushButton(this, 765, 500, 'step', doStep);
            continueButton.visible = false;
            //draw();
            colorHSV = new ColorHSV();
            psprite = Sprite(addChild(new Sprite));
        }
        
        private function doStep(e:Event):void 
        {
            render(null);
        }
        
        private function doPlay(e:Event):void 
        {
            isStopped = false;
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function doStop(e:Event):void 
        {
            removeEventListener(Event.ENTER_FRAME, render);
            isStopped = true;
        }
        
        private function onEmptyWidthSignalHandler(emptyWidth:uint):void 
        {
            
        }
        
        private function onPositionSignalHandler(position:int):void 
        {
            var g:Graphics = psprite.graphics;
            //g.clear();
            g.lineStyle(0);
            g.beginFill(0);
            /*
            g.drawRect(
                position % tileAmount * TILE_SCALE + 1,
                uint(position / tileAmount) * TILE_SCALE + 1, 
                4, 
                4
            );
            */
            drawRectangleAt(g, position,4);
            g.endFill()
            
        }
        
        private function onMapChange():void 
        {
            removeEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = true;
            var timer:Timer = new Timer(1000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, afterMapChange, false, 0, true);
            if (!isStopped) timer.start();
        }
        
        private function afterMapChange(e:TimerEvent):void 
        {
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function onLineSignal():void 
        {
            removeEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = true;
        }
        
        private function doContinue(e:Event):void 
        {
            addEventListener( Event.ENTER_FRAME, render );
            continueButton.visible = false;
        }
        
        private function drawMap(map:Array):void 
        {
            colorHSV.h = (counter++)%360
            var g:Graphics = csprite.graphics;
            g.clear();
            g.lineStyle(0);
            g.beginFill(colorHSV.value);
            for (var i:int = 0; i < map.length; i++) 
            {
                var item:uint = map[i];
                drawRectangleAt(g,i,TILE_SCALE-2);
            }
        }
        
        private function drawRectangleAt(g:Graphics, i:int, size:Number):void 
        {
            g.drawRect(
                i % tileAmount * TILE_SCALE + 1,
                uint(i / tileAmount) * TILE_SCALE + 1, 
                size, 
                size
            );
        }
        
        
        static public function traceIt(msg:String):void 
        {
            debugger.traceThis(msg)
            
        }
        private function cTrace(msg:String):void 
        {
            traceIt(msg);
        }
        private function draw():void 
        {
            while (addChild( mapLogic.create() ).y<480) 
            {
                
            }
        }
        
        private function render( e:Event ):void
        {
            addChild( mapLogic.create() );
        }
    }
}

import com.bit101.components.PushButton;
import com.bit101.components.TextArea;
import com.bit101.components.VBox;
import flash.display.*;
import flash.events.Event;
import flash.text.TextField;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;
    
internal class MapLogic
{
    private var _map:Array = [];
    private var gridW:int;
    private var gridH:int;
    private var tileMax:int;
    private var tileScale:int = 10;
    private var icount:uint;
    private var tiles:Vector.<Tile>;
    private var lineCounter:uint;
    private var mapLength:uint;
    private var mapIndex:uint;
    public  var emptyPos:int = 0;
    public var lengthChange:ISignal;
    public var mapSignal:ISignal;
    public var lineSignal:ISignal;
    public var positionSignal:ISignal;
    private var emptyWidth:int;
    private var position:int;
    public var emptyWidthSignal:ISignal;
    
    public function MapLogic( gridW:int, gridH:int, tileMax:int, tileScale:int ):void
    {
        this.gridW        = gridH;
        this.gridH        = gridW;
        this.tileMax        = tileMax;
        this.tileScale    = tileScale;
        mapSignal = new Signal(Array);
        lengthChange = new Signal();
        lineSignal = new Signal();
        tiles = Vector.<Tile>([]);
        positionSignal = new Signal(int);
        emptyWidthSignal = new Signal(int);
    }

    public function create():Tile
    {
        position = -1;
        emptyWidth = 0;
        icount = 0;
        
        for (mapIndex = emptyPos; mapIndex < emptyPos +500 ; mapIndex++ )
        //for ( var i:int = emptyPos; i < emptyPos +500 ; i++ )
        {
            ///*
            if (!setPosition()) 
            {
                break;
            }
            /*/
            icount++;
            if ( !_map[i] && position == -1 ){
                position = i;
                positionSignal.dispatch(position);
                emptyWidth++;
            } else if ( emptyWidth >= tileMax ){
                break;
            } else if ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) {
                emptyWidth++;
            } else if ( position != -1 ) {
                break;
            }
            //*/
        }
        //cTrace( "i : " + i );
        cTrace( "mapIndex : " + mapIndex );
        cTrace( "emptyWidth : " + emptyWidth );
        cTrace( "_map.length : " + _map.length );
        cTrace( "icount : " + icount );
        var ww:int    = int( Math.random() * emptyWidth ) + 1;
        cTrace( "ww : " + ww );
        
        var p:int = position;
        cTrace( "p : " + p );
        for ( var yy:int = 0; yy < ww; yy++ ){
            for ( var xx:int = 0; xx < ww; xx++ ){
                _map[p] = 1;
                p++;
            }
            p += gridW - ww;
            var delta:Number = (gridW - ww);
        }
        cTrace( "delta : " + delta );
        trace( "_map : " + _map );
        mapSignal.dispatch(_map);
        if (_map.length!=mapLength) 
        {
            lengthChange.dispatch();
        }
        mapLength = _map.length
        emptyPos = position + ww;
        cTrace( "emptyPos : " + emptyPos );
        
        var px:int = position % gridW * tileScale;
        var py:int = position == 0 ? 0 : int( position / gridW ) * tileScale;
        cTrace( "(ww*ww) : " + (ww * ww) );
        if ( px==0) 
        {
            lineCounter++;
            lineSignal.dispatch();
        }
        var tile:Tile =       new Tile( px, py, ww * tileScale, ww * tileScale );    
        tiles[tiles.length] = tile;
        cTrace('---------------------------------------');
        return tile;
    }
     private function setPosition():Boolean 
    {
        var output:Boolean = true;
        icount++;
        cTrace( "icount : " + icount );
        if ( !_map[mapIndex] && position == -1 ){
            position = mapIndex;
            positionSignal.dispatch(position);
            emptyWidth++;
            emptyWidthSignal.dispatch(emptyWidth);
        } else if ( emptyWidth >= tileMax )
        {
            cTrace( "( emptyWidth >= tileMax ) : " + ( emptyWidth >= tileMax ) );
            output = false;
        } else if ( !_map[mapIndex] && !( mapIndex % gridW == 0 && mapIndex != emptyPos ) ) 
        {
            emptyWidth++;
            emptyWidthSignal.dispatch(emptyWidth);
        } else if ( position != -1 ) 
        {
            cTrace( "( position != -1 ) : " + ( position != -1 ) );
            output = false;
        }
        return output
    }   
    private function cTrace(arg1:String):void 
    {
        Tiling.traceIt(arg1);
    }
}

internal class Tile extends Shape
{
    public function Tile( _x:int, _y:int, _w:int, _h:int ):void
    {
        this.x = _x;
        this.y = _y;
        
        graphics.lineStyle( 1, 0x000000 );
        graphics.drawRect( 0, 0, _w, _h );
    }
}
class Debugger extends VBox
{
    private var _textField:TextField;
    private var _msprite:Sprite;
    public function Debugger(msprite:Sprite) 
    {
        super();
        _msprite = msprite;
        _msprite.addChild(this);
        addChildAt(new PushButton(null, 0, 0, "clear", doClear), numChildren);;
        var textArea:TextArea = new TextArea();
        addChildAt(textArea, numChildren);
        _textField = textArea.textField
        //textField.defaultTextFormat = new TextFormat("Lucida Console",11);
        x = 465;
        //border = true;
        textArea.setSize(465, 465);
    }
    
    private function doClear(e:Event):void 
    {
        _textField.text = "";
    }
    
    public function get textField():TextField 
    {
        return _textField;
    }
    
    public function set textField(value:TextField):void 
    {
        _textField = value;
    }
    
    public function traceThis(msg:String):void 
    {
        textField.appendText(msg + "\n");
        textField.scrollV = textField.maxScrollV;
        
    }
}






















