/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nP9H
 */

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
    
    public class FlashTest extends Sprite {
        private var cursor:StarDustCursor;
        
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0x000000);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            addChild(bg);
            var stats:Stats = new Stats();
            addChild(stats);
            cursor = new StarDustCursor(this);
        }
    }
}

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.ui.Mouse;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.IObjectTween;
import org.libspark.betweenas3.ITween;

class StarDustCursor extends Sprite {
    private var container:DisplayObjectContainer;
    public function StarDustCursor(container:DisplayObjectContainer) {
        x = container.mouseX;
        y = container.mouseY;
        mouseEnabled = false;
        Mouse.hide();
        this.container = container;
        this.container.addChild(this);
        this.container.addEventListener(MouseEvent.MOUSE_MOVE, onContainerMouseMove);
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function onContainerMouseMove(e:MouseEvent):void {
        if(e.currentTarget == container) {
            x = e.stageX;
            y = e.stageY;
        }
    }
    
    private var cnt:uint = 0;
    private var curHue:Number = 0;
    private var starPool:Vector.<Star> = new Vector.<Star>();
    private var tc:Color = new Color();
    private var fc:Color = new Color();
    private function onEnterFrame(e:Event):void {
        var star:Star;
        if(starPool.length == 0) {
            star = new Star(x, y, 7.5, new Color(0xff, 0xff, 0xff));
        } else {
            star = starPool.pop();
            star.init(x, y, 7.5, new Color(0xff, 0xff, 0xff));
        }
        container.addChild(star);
        var sina:Number = Math.sin(Math.PI * 2 * Math.random());
        var cosa:Number = Math.cos(Math.PI * 2 * Math.random());
        var length:Number = (18 * Math.random() * 12) / 4;
        tc.setHSV(curHue, 0.8, 0.7);
        fc.setRGB(0xff, 0xff, 0xff);
        var tween:IObjectTween = BetweenAS3.tween(
        star,
        {rotationZ:360, x:star.x + length * cosa, y:star.y + length * sina, alpha:0.0, span:17.5, color:{r:tc.r, g:tc.g, b:tc.b}},
        {rotationZ:0, x:star.x, y:star.y, alpha:1.0, span:7.5, color:{r:fc.r, g:fc.r, b:fc.b}},5
        );
        tween.onComplete = function():void {
            var star:Star = tween.target as Star;
            star.destroy();
            container.removeChild(star);
            starPool.push(star);
        };
        tween.play();
        
        curHue += 0.01;
        if(cnt++ % 2 == 0)
        stage.invalidate();
    }
}

class Color {
    public var r:uint;
    public var g:uint;
    public var b:uint;
    
    public function Color(r:uint = 0, g:uint = 0, b:uint = 0) {
        this.r = r;
        this.g = g;
        this.b = b;
    }
    
    public function toUInt():uint {
        return r << 16 | g << 8 | b;
    }
    public function toString():String {
        return "Color[r:" + r + ", g:" + g + ", b:" + b + "]";
    }
    public function setRGB(r:uint, g:uint, b:uint):Color {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }
    
    public function setHSV(h:Number, s:Number, v:Number):Color {
        var i:int;
        var f:Number, p:Number, q:Number, t:Number;
        if(s == 0) {
            r = g = b = v * 255;
            return this;
        }
        h = (h - Math.floor(h)) * 6;
        i = Math.floor(h);
        f = h - Math.floor(h);
        p = v * (1 - s);
        q = v * (1 - s * f);
        t = v * (1 - s * (1 - f));
        switch(i){
            case 0:
            r = v * 255;
            g = t * 255;
            b = p * 255;
            break;
            case 1:
            r = q * 255;
            g = v * 255;
            b = p * 255;
            break;
            case 2:
            r = p * 255;
            g = v * 255;
            b = t * 255;
            break;
            case 3:
            r = p * 255;
            g = q * 255;
            b = v * 255;
            break;
            case 4:
            r = t * 255;
            g = p * 255;
            b = v * 255;
            break;
            default:
            r = v * 255;
            g = p * 255;
            b = q * 255;
            break;
        }
        return this;
    }
}

class Star extends Shape {
    public var _color:Color = new Color();
    public var _span:Number = 10;
    public function Star(x:Number = 0, y:Number = 0, span:Number = 10, color:Color = null) {
        init(x, y, span, color);
    }
    public function init(x:Number = 0, y:Number = 0, span:Number = 10, color:Color = null):Object {
        this.x = x;
        this.y = y;
        _color = color = null ? new Color() : color;
        _span = span;
        update();
        removeEventListener(Event.RENDER, update);
        addEventListener(Event.RENDER, update);
        return this;
    }
    
    public function destroy():void {
        removeEventListener(Event.RENDER, update);
    }
    
    public function set color(color:Color):void {
        _color = color;
        updated = false;
    }
    
    public function get color():Color {
        return _color;
    }
    
    public function set span(span:Number):void {
        _span = span;
        updated = false;
    }
    
    public function get span():Number {
        return _span;
    }
    
    public var updated:Boolean = false;
    public function update(e:Event = null):void {
        if(updated)
        return
        updated = true;
        var i:int;
        var sina:Number = span * (0.1 + 0.1 * span / 20);
        graphics.clear();
        graphics.beginFill(color.toUInt());
        for(i = 0; i < 5; i++) {
            sina = Math.sin(Math.PI * 2 / 5 * i);
            cosa = Math.cos(Math.PI * 2 / 5 * i);
            if(i == 0) {
                graphics.moveTo(cosa * span, sina * span);
            } else {
                graphics.lineTo(cosa * span, sina * span);
            }
            sina = Math.sin(Math.PI * 2 / 5 * i + Math.PI / 2 / 5 * 2);
            cosa = Math.cos(Math.PI * 2 / 5 * i + Math.PI / 2 / 5 * 2);
            graphics.lineTo(cosa * innerSpan, sina * innerSpan);
        }
        i = 0;
        sina = Math.sin(Math.PI * 2 / 5 * i);
        cosa = Math.cos(Math.PI * 2 / 5 * i);
        graphics.lineTo(cosa * span, sina * span);
        graphics.endFill();
    }
}

