/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nObp
 */

package//
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;

    [SWF(width = '465', height = '465')]
    //
    public class OtsuThresholding2 extends Sprite//
    {
        private var cam : Camera;
        private var dst : BitmapData;
        private var ofscr : BitmapData;
        private var blurFilter : BlurFilter = new BlurFilter(2, 2, 1);
        private var edge3 : ConvolutionFilter = new ConvolutionFilter(3, 3, [0, 1, 0, 1, -4, 1, 0, 1, 0]);
        private var graysc : ColorMatrixFilter = new ColorMatrixFilter([0.3, 0.59, 0.11, 0, 0, 0.3, 0.59, 0.11, 0, 0, 0.3, 0.59, 0.11, 0, 0, 0, 0, 0, 1, 0]);
        private var sums : Vector.<Number> = new Vector.<Number>(256, true);
        private var hmul : Vector.<Number> = new Vector.<Number>(256, true);
        private var fcnt : int;

        function OtsuThresholding2()//
        {
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            stage.quality = 'low';
            stage.frameRate = 24;
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            opaqueBackground = 0x0;

            addChild(new Bitmap(new BitmapData(465, 465, false, 0x0)));

            cam = Camera.getCamera();
            cam.setMode(512, 384, stage.frameRate);

            var vid : Video = new Video(512, 384);
            vid.attachCamera(cam);

            var bm : Bitmap = new Bitmap(dst = new BitmapData(512, 384, false));
            bm.opaqueBackground = 0x0;
            bm.x = (465 - 512) >> 1;
            bm.y = (465 - 384) >> 1;
            addChild(bm);

            ofscr = dst.clone();

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void//
        {
            fcnt++;

            var rect : Rectangle = dst.rect;
            var dstp : Point = rect.topLeft;

            dst.lock();

            cam.drawToBitmapData(dst);

            dst.applyFilter(dst, rect, dstp, graysc);

            dst.applyFilter(dst, rect, dstp, blurFilter);

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ OTSU

            var threshold : uint = 0;

            var histo0 : Vector.<Number> = dst.histogram() [0];
            var npix : int = dst.width * dst.height;
            var wb : Number = 0.0;
            var sum : Number = 0.0;

            var i : uint = 256;

            while (i--)//
            {
                var d : Number = i * histo0 [i];

                hmul[i] = d;

                sum += d;

                sums[i] = sum;
            }

            d = 0.0;
            sum = 0.0;

            i = 256;

            while (i--)
            {
                wb += histo0[i];
                if (wb == 0.0) continue;

                var wf : Number = npix - wb;
                if (wf == 0.0) break;

                sum += hmul[i];

                var mean : Number = (sum / wb) - ((sums[i] - sum) / wf);

                var v : Number = wb * wf * mean * mean;

                if (v > d)
                {
                    d = v;

                    threshold = i;
                }
            }

            ofscr.copyPixels(dst, rect, dstp);

            dst.fillRect(rect, 0xFF000000);

            if (threshold < 8) dst.threshold(ofscr, rect, dstp, '>', (fcnt & 127), 0xFFFFFFFF, 0x000000FF, false);
            else dst.threshold(ofscr, rect, dstp, '>', threshold, 0xFFFFFFFF, 0x000000FF, false);
            trace('threshold: ' + (threshold));

            dst.applyFilter(dst, rect, dstp, edge3);
            // dst.applyFilter(dst, rect, dstp, laplacianEdgeConvo);

            dst.unlock();
        }
    }
}