/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nOFs
 */

//http://parpue.net/web/138
package
{ 
    import Box2D.Collision.b2AABB; 
    import Box2D.Collision.Shapes.b2PolygonDef; 
    import Box2D.Common.Math.b2Vec2; 
    import Box2D.Dynamics.b2Body; 
    import Box2D.Dynamics.b2BodyDef; 
    import Box2D.Dynamics.b2DebugDraw; 
    import Box2D.Dynamics.b2World; 
    import flash.display.Sprite; 
    import flash.events.Event; 
    import flash.events.MouseEvent; 
    public class PaperVisionTest extends Sprite 
    { 
        private var world : b2World; 
        private var boxBody : b2Body; 
        private var pvView : PVView; 
        public function PaperVisionTest() 
        { 
            //stage.addEventListener(MouseEvent.CLICK, clickHandler); 
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);  
            pvView = new PVView; 
            pvView.x = -100; 
            pvView.y = -100; 
            addChild(pvView);
            run(); 
        } 
        //private function clickHandler(event : MouseEvent) : void 
        private function run() : void
        {
            var worldAABB : b2AABB = new b2AABB(); 
            worldAABB.lowerBound.Set(-100, -100); 
            worldAABB.upperBound.Set(100, 100); 
            var gravity : b2Vec2 = new b2Vec2(0, 10); 
            world = new b2World(worldAABB, gravity, true); 
            var floorBodyDef : b2BodyDef = new b2BodyDef(); 
            floorBodyDef.position.Set(2.15, 3); 
            var floorShapeDef : b2PolygonDef = new b2PolygonDef(); 
            floorShapeDef.SetAsBox(2, 0.1); 
            var floor : b2Body = world.CreateBody(floorBodyDef); 
            floor.CreateShape(floorShapeDef); 
            var boxBodyDef : b2BodyDef = new b2BodyDef(); 
            boxBodyDef.position.Set(2.5, 1); 
            var boxShapeDef : b2PolygonDef= new b2PolygonDef(); 
            boxShapeDef.SetAsOrientedBox(0.3, 0.2, new b2Vec2(0, 0), 0.9); 
            boxShapeDef.density = 1;
            boxShapeDef.restitution = 0.75;
            boxBody = world.CreateBody(boxBodyDef); 
            boxBody.CreateShape(boxShapeDef); 
            boxBody.SetMassFromShapes(); 
            var debugDraw : b2DebugDraw = new b2DebugDraw(); 
            debugDraw.m_sprite = this; 
            debugDraw.m_drawScale = 100;
            debugDraw.m_fillAlpha = 0.6;
            debugDraw.m_lineThickness = 1;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit; 
            world.SetDebugDraw(debugDraw); 
        } 
        private function enterFrameHandler(event : Event) : void 
        { 
            if (world == null) 
            { 
                return; 
            } 
            world.Step(1 / 24, 10); 
            var b2vec : b2Vec2 = boxBody.GetPosition(); 
            pvView.setCubePosition(b2vec.x * 100, b2vec.y * 100, boxBody.GetAngle()); 
        } 
    } 
} 
    import Box2D.Dynamics.b2Body; 
    import org.papervision3d.lights.PointLight3D; 
    import org.papervision3d.materials.ColorMaterial; 
    import org.papervision3d.materials.shadematerials.PhongMaterial; 
    import org.papervision3d.materials.special.CompositeMaterial; 
    import org.papervision3d.materials.utils.MaterialsList; 
    import org.papervision3d.materials.WireframeMaterial; 
    import org.papervision3d.objects.primitives.Cube; 
    import org.papervision3d.view.BasicView; 
    class PVView extends BasicView
    { 
        private var b2BodyList : Array; 
        private var _light : PointLight3D; 
        private var cube : Cube; 
        
        public function PVView()
        { 
            b2BodyList = new Array(); 
            camera.z = -50; 
            camera.x = -40; 
            camera.y = -40; 
            _light = new PointLight3D; 
            _light.x = 0; 
            _light.y = 0; 
            _light.z = 40; 
            var colorMaterial : ColorMaterial = new ColorMaterial(0x77FF77, 1); 
            var wireMaterial : WireframeMaterial = new WireframeMaterial(0x66FF66, 1); 
            var phongMaterial : PhongMaterial = new PhongMaterial( _light, 0xCCDDCC, 0xDDEEDD, 1 ); 
            var compositeMaterial : CompositeMaterial = new CompositeMaterial(); 
            compositeMaterial.addMaterial(colorMaterial); 
            compositeMaterial.addMaterial(phongMaterial); 
            compositeMaterial.addMaterial(wireMaterial); 
            var materialsList : MaterialsList = new MaterialsList; 
            materialsList.addMaterial(compositeMaterial, "all"); 
            cube = new Cube(materialsList, 60, 40, 40); 
            cube.x = 2.5 * 100; 
            cube.y = 1 * 100; 
            scene.addChild(cube); 
            startRendering();  
        } 
        public function setCubePosition(x : Number, y : Number, rotationY) 
        { 
            cube.x = x; 
            cube.z = y; 
            rotationY = rotationY * 180; 
            cube.rotationY = rotationY; 
        } 
    }
     