/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nNC4
 */

package {
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.lights.PointLight3D;
    import flash.display.*;
    import flash.filters.*;
    import flash.events.*;

    public class Main extends Sprite {
        
        private var cube1:Cube;
        private var cube2:Cube;
        private var world1:BasicView;
        private var world2:BasicView;
        private var light:PointLight3D;
        private var materials:MaterialsList;
        
        public function Main() {
            
            world1 = new BasicView();
            addChild(world1);
            world2 = new BasicView();
            addChild(world2);
            
            light = new PointLight3D(false);
            light.x = -100;
            light.y = 0;
            light.z = -250;
            
            materials = new MaterialsList({all : new FlatShadeMaterial(light, 0x336699 )});
            cube1 = new Cube(materials,250,250,250);
            cube2 = new Cube(materials,250,250,250);
            world1.scene.addChild(cube1);
            world2.scene.addChild(cube2);

            world1.startRendering();
            world2.startRendering();

            addEventListener(Event.ENTER_FRAME,loop);
            addEventListener(Event.ENTER_FRAME,loop);

            //world2.blendMode = "add";
            var blur : BlurFilter = new BlurFilter();
            blur.blurX = 16;//水平方向のぼかし
            blur.blurY = 16;//垂直方向のぼかし
            var matrix:Array = [0.3, 0.59, 0.11, 0, 0,
           0.3, 0.59, 0.11, 0, 0,
           0.3, 0.59, 0.11, 0, 0,
           0, 0, 0, 1, 0];
           var grayscaleFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
            world2.filters = [blur,grayscaleFilter];           
            
            function loop(e:Event):void{
            cube1.rotationX +=  2;
            cube1.rotationY +=  2;
            cube2.rotationX +=  5;
            cube2.rotationY +=  5;
    
            }    
        }
    }
}