/**
 * Copyright hacker_lu4lwrz2 ( http://wonderfl.net/user/hacker_lu4lwrz2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nMrc
 */

// forked from paq's [Stardust] COLORFUL
package 
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author paq89
     */
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    public class Main extends Sprite 
    {
        static private var DRAW_SCALE:Number = 100;
        
        private var container:Sprite;
        private var emitter:Box2DEmitter;
        private var world:b2World;
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // 背景を作成
            var background:Sprite = new Sprite();
            var g:Graphics = background.graphics;
            g.beginFill(0x000000);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            addChild(background);
            container = new Sprite();
            addChild(container);
            
            // Box2D
            box2DInit();
            
            // Stardust
            stardustInit();
            
            // イベントリスナーの登録
            addEventListener(Event.ENTER_FRAME, loop);
            
            //デバッグ用
            //addChild(new Stats());
        }
        
        private function loop(e:Event):void 
        {
            // エミッターの更新
            emitter.step();
            
            // Box2Dを更新
            world.Step(1 / 24, 10);
        }
        
        private function stardustInit():void 
        {
            emitter = new Box2DEmitter(new SteadyClock(0.5), world)
            var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(container);
            renderer.addEmitter(emitter);
        }
        
        private function box2DInit():void 
        {
            // ワールドを作成
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            // 重力
            var gravity:b2Vec2 = new b2Vec2(0, -2);
            world = new b2World(worldAABB, gravity, true);
            
            // 床を作成
            var floorBodyDef:b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(465 * 0.5 / DRAW_SCALE, 515 / DRAW_SCALE);
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(465 * 0.5 / DRAW_SCALE, 50 / DRAW_SCALE);
            var floor:b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);
            
            // 天井を作成
            var topBodyDef:b2BodyDef = new b2BodyDef();
            topBodyDef.position.Set(465 * 0.5 / DRAW_SCALE, -50 / DRAW_SCALE);
            var topShapeDef:b2PolygonDef = new b2PolygonDef();
            topShapeDef.SetAsBox(465 * 0.5 / DRAW_SCALE, 50 / DRAW_SCALE);
            var top:b2Body = world.CreateBody(topBodyDef);
            top.CreateShape(topShapeDef);
            
            // デバッグ描画
            //var debugDraw:b2DebugDraw = new b2DebugDraw();
            //debugDraw.m_sprite = container;
            //debugDraw.m_drawScale = DRAW_SCALE;
            //debugDraw.m_fillAlpha = 0.8;
            //debugDraw.m_lineThickness = 1;
            //debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            //world.SetDebugDraw(debugDraw);
        }
    }
    
}

import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2CircleShape;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2PolygonShape;
import Box2D.Collision.Shapes.b2Shape;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.events.Event;
import frocessing.color.ColorHSV;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
import idv.cjcat.stardust.common.actions.triggers.LifeTrigger;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Mask;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Spawn;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.Line;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

class Box2DEmitter extends Emitter2D
{
    public function Box2DEmitter(clock:Clock, world:b2World)
    {
        super(clock);
        
        var doc:DisplayObjectClass = new DisplayObjectClass();
        doc.displayObjectClass = Circle;
        doc.constructorParams = [world, false];
        
        addInitializer(doc);
        addInitializer(new Position(new RectZone(222, 300, 10, 10)));
        addInitializer(new Life(new UniformRandom(50, 0)));
        addInitializer(new Scale(new UniformRandom(3, 3)));
        
        var commonActions:CompositeAction = new CompositeAction();
        commonActions.mask = 1;
        commonActions.addAction(new Age());
        commonActions.addAction(new DeathLife());
        commonActions.addAction(new ScaleCurve(5, 20));
        
        addAction(commonActions);
    }
}

class Circle extends Sprite
{
    static private const DRAW_SCALE:Number = 100;
    static private var col:int = 0;
    
    private var _world:b2World;
    private var _circleBody:b2Body;
    private var _circleShape:b2CircleShape;
    private var _scaleX:Number;
    private var _x:Number;
    private var _y:Number;
    private var _move:Boolean;
    
    public function Circle(world:b2World, move:Boolean = false):void 
    {
        super();
        
        var color:ColorHSV = new ColorHSV(col+=5, 0.7);
        graphics.beginFill(color.value, 0.5);
        graphics.drawCircle(0, 0, 10);
        graphics.beginFill(color.value, 1);
        graphics.drawCircle(0, 0, 8);
        
        _world = world;
        _move = move;
        
        var circleBodyDef:b2BodyDef = new b2BodyDef(); 
        circleBodyDef.position.Set(x / DRAW_SCALE, y / DRAW_SCALE); 
        
        var circleShapeDef:b2CircleDef = new b2CircleDef();  
        circleShapeDef.radius = 0.001;  
        circleShapeDef.density = 1;  
        circleShapeDef.friction = 0.5;  
        circleShapeDef.restitution = 0.5;  
        
        _circleBody = world.CreateBody(circleBodyDef);  
        _circleShape = _circleBody.CreateShape(circleShapeDef) as b2CircleShape;  
        _circleBody.SetMassFromShapes();  
        
        addEventListener(Event.REMOVED, onRemoved );
        addEventListener(Event.ENTER_FRAME, onEnterFrame)
    }
    
    private function onEnterFrame(e:Event):void 
    {
        if (_move) _circleBody.SetXForm(new b2Vec2(x / DRAW_SCALE, y / DRAW_SCALE), rotation);
        if (_scaleX != scaleX) _circleShape.m_radius = scaleX / 10;
        if (_x != x) _circleBody.SetXForm(new b2Vec2(x / DRAW_SCALE, _circleBody.GetPosition().y), rotation);
        if (_y != y) _circleBody.SetXForm(new b2Vec2(_circleBody.GetPosition().x, y / DRAW_SCALE), rotation);
        _scaleX = scaleX;
        _x = x;
        _y = y;
        x = _circleBody.GetPosition().x * DRAW_SCALE;
        y = _circleBody.GetPosition().y * DRAW_SCALE;
    }
    
    private function onRemoved(e:Event):void 
    {
        removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        removeEventListener(Event.REMOVED, onRemoved);
        _world.DestroyBody(_circleBody);
    }
}