/**
 * Copyright komlev88 ( http://wonderfl.net/user/komlev88 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nMWN
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.Dictionary;
    
    [SWF (width = "256", height = "256", frameRate = "31", backgroundColor = "#000000")]
    public class GameOfLife extends Sprite
    {
        private var _bmpDt:BitmapData;
        
        public function GameOfLife()
        {
            super();
            
            _bmpDt = new BitmapData(256, 256, true, 0x0);
            addChild(new Bitmap(_bmpDt));
            
            for (var i:int = 0; i < 5; i++)
            {
                var red:uint = 90 + (Math.random() * 165) & 0xff;
                var green:uint = 90 + (Math.random() * 165) & 0xff;
                var blue:uint = 90 + (Math.random() * 165) & 0xff;
                var alpha:uint = 0xff;
                
                var color:uint = (alpha << 24) | (red << 16) | (green << 8) | (blue);
                
                var x:int = Math.random() * _bmpDt.width;
                var y:int = Math.random() * _bmpDt.height;
                
                _bmpDt.setPixel32(x, y, color);
            }
            
            addEventListener(Event.ENTER_FRAME, draw);
        }
        
        private function draw(e:Event = null):void
        {
            var pixel:Pixel;
            var result:Vector.<Pixel> = new Vector.<Pixel>();
            var dict:Dictionary = new Dictionary();
            
            _bmpDt.lock();
            
            for (var y:int = 0; y < _bmpDt.height; y++)
            {
                for (var x:int = 0; x < _bmpDt.width; x++)
                {
                    var color:uint = _bmpDt.getPixel32(x, y);
                    if ( ((color >> 24) & 0xff) == 0)
                    {
                        continue;
                    }
                    
                    pixel = sprout(x, y, color);
                    
                    if (pixel != null)
                    {
                        var key:String = pixel.x + "_" + pixel.y;
                        if (dict[key] != null)
                        {
                            var tmpPxl:Pixel = dict[key];
                            
                            if (tmpPxl.lightness > pixel.lightness)
                            {
                                tmpPxl.x = pixel.x;
                                tmpPxl.y = pixel.y;
                                tmpPxl.color = pixel.color;
                            }
                        }
                        else
                        {
                            dict[key] = pixel;
                        }
                    }
                }
            }
            
            var point:Point = new Point();
            var rect:Rectangle = new Rectangle(0, 0, 2, 2);
            
            for each(pixel in dict)
            {
                rect.x = pixel.x;
                rect.y = pixel.y - 2;
                point.x = pixel.x;
                point.y = pixel.y;
                
                _bmpDt.setPixel32(pixel.x, pixel.y, pixel.color);
                _bmpDt.applyFilter(_bmpDt, rect, point, new BlurFilter(2, 2, 1));
            }
            
            _bmpDt.unlock();
        }
        
        public function sprout(x:int, y:int, color:uint):Pixel
        {
            var newX:int = x + int(int(Math.random() * 3) - 1);
            var newY:int = y + int(int(Math.random() * 3) - 1);
            
            var width:int = _bmpDt.width;
            var height:int = _bmpDt.height;  
            
            newX = newX > 0 ? newX <= width ? newX : width - 1 : 0;
            newY = newY > 0 ? newY <= height ? newY : height - 1 : 0;
            
            var red:uint = (color >> 16) & 0xff;
            var green:uint = (color >> 8) & 0xff;
            var blue:uint = color & 0xff;
            
            var lightness:uint = (red + green + blue) / 3;
            
            var newColor:uint =  _bmpDt.getPixel32(newX, newY);
            var newRed:uint = (newColor >> 16) & 0xff;
            var newGreen:uint = (newColor >> 8) & 0xff;
            var newBlue:uint = newColor & 0xff;
            
            var newLightness:uint = (newRed + newGreen + newBlue) / 3;
            
            var redDiff:int = red - newRed;
            redDiff = (redDiff ^ (redDiff >> 31))-(redDiff >> 31);
            
            var greenDiff:int = green - newGreen;
            greenDiff = (greenDiff ^ (greenDiff >> 31))-(greenDiff >> 31);
            
            var blueDiff:int = blue - newBlue;
            blueDiff = (blueDiff ^ (blueDiff >> 31))-(blueDiff >> 31);
            
            if ((redDiff < 0x20) && (greenDiff < 0x20) && (blueDiff < 0x20))
            {
                return null;
            }
            
            if ((lightness > newLightness))
            {
                x = newX;
                y = newY;
            }
            else
            {
                red = ((newRed + red) / 2) & 0xff;
                green = ((newGreen + green) / 2) & 0xff;
                blue = ((newBlue + blue) / 2) & 0xff;
            }
            
            color = (0xff << 24) | (red << 16) | (green << 8) | (blue);
            
            return new Pixel(x, y, color);
        }
    }
}

class Pixel
{
    public var x:int;
    public var y:int;
    public var color:uint;
    
    public function Pixel(x:int, y:int, color:int)
    {
        this.x = x;
        this.y = y;
        this.color = color;
    }
    
    public function get lightness():uint
    {
        var result:uint = (((color >> 16) & 0xff) + ((color >> 8) & 0xff) + (color & 0xff)) / 3;
        return result;
    }
}