/**
 * Copyright nsos ( http://wonderfl.net/user/nsos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nMCT
 */

// forked from motikawa_rgm's マリージ
package 
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import jp.progression.commands.lists.LoaderList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.events.ExecuteEvent;
    import net.hires.debug.Stats;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Back;
    import org.libspark.betweenas3.tweens.ITween;
    /**
     * ...
     * @author motikawa/tokazaki
     */
    [SWF(width = 465, height = 465, frameRate = 60, backgroundColor = 0x000000)]
    public class Mariji extends Sprite 
    {
        private static const LIMIT_TIME:int = 100;
        private static const TICK_DELAY:int = 33;
        private static var _scoreUpCount:int = 100;
        
        private var _emitter:ItemEmitter;
        private var _score:Score;
        private var _timeNum:DotNumber;
        private var _char:Charactor;
        private var _tick:Timer;
        private var _startBtn:PushButton;
        private var _startTime:int;
        public function Mariji():void 
        {
            _loadAssets();
        }
        private function _loadAssets():void
        {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, _onGlobalError);
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, _onAssetsLoadComplete);
            l.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/e0/e046/e046ef99d94b80c5c5bcb74c85a72cab6a9b12df"), new LoaderContext(true));
        }
        private function _onGlobalError(e:UncaughtErrorEvent):void
        {
            e.preventDefault();
            trace(e);
        }
        
        private function _onAssetsLoadComplete(e:Event):void
        {
            var bmd:BitmapData = ((e.target as LoaderInfo).content as Bitmap).bitmapData,
                obj:Object = ImageParser.parseImage(bmd);
                
            (e.target as LoaderInfo).removeEventListener(Event.COMPLETE, _onAssetsLoadComplete);
            
            DotNumber.setNumberBitmapData(obj.numbers);
            Kriboo.initImage(obj.kuribo);
            Kinoko.initImage(obj.kinoko);
            Charactor.initImages(obj.smallImages, obj.largeImages, obj.deathImage);
            
            graphics.beginBitmapFill(obj.background, null, false);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            addChildAt(_timeNum = new DotNumber(4), 0);
            _timeNum.x = 386;
            _timeNum.y = 30;
            
            _score = new Score(obj.scoreBase);
            addChildAt(_score, 0);
            _score.x = Math.floor((465 - _score.width) * .5);
            
            _startBtn = new PushButton(this, Math.floor(465 * .5 - 50), Math.floor(465 * .5 - 10), "start", _onClick);
            _startBtn.width = 100;
            _startBtn.height = 20;
            
            addChildAt(_char = new Charactor(), 0);
            _char.x = 230;
            _char.y = 398;
            _tick = new Timer(TICK_DELAY, 0);
            _tick.addEventListener(TimerEvent.TIMER, _onTick);
            
            var con:Sprite = addChildAt(new Sprite(),0) as Sprite;
            _emitter = new ItemEmitter(new Point(233, -30), con, _char, 30);
            _emitter.addEventListener(ItemHitEvent.ITEM_HIT, _onItemHit);
            
        }
        private function _onItemHit(e:ItemHitEvent):void
        {
            _char.setScore(e.score);
            if (e.score == 1) 
            {
                _score.score ++;
                if (_score.score == _scoreUpCount) 
                {
                    _startTime    += 20 * 1000;
                    _scoreUpCount += 100;
                }
            }
            else _startTime -= 500;
        }
        private function _onClick(e:MouseEvent):void
        {
            _startBtn.enabled = false;
            
            var dx:Number = Math.floor(465 * .5),
                dy:Number = Math.floor(465 * .5),
                tween:ITween = BetweenAS3.serial(
                                                    BetweenAS3.tween(_startBtn, { scaleX:0, scaleY:0 , x:dx, y:dy }, null, .6, Back.easeIn),
                                                    BetweenAS3.removeFromParent(_startBtn)
                                                );
            tween.onComplete = _startGame;
            tween.play();
        }
        private function _startGame():void
        {
            _startTime = getTimer();
            _timeNum.num = 0;
            _score.score = 0;
            _char.startMove();
            _tick.start();
        }
        private function _gameOver():void
        {
            _timeNum.num = 0;
            _tick.stop();
            _emitter.removeItems();
            var owner:DisplayObjectContainer = this;
            _char.death(function():void
                        {
                            new GameOverScreen(_score.score, owner, Math.floor((465 - 200) * .5) , Math.floor((465 - 80) * .5), _reload);
                        });
        }
        private function _reload():void
        {
            _startBtn.scaleX = _startBtn.scaleY = 1;
            _startBtn.x = Math.floor(465 * .5 - 50);
            _startBtn.y = Math.floor(465 * .5 - 10);
            _startBtn.enabled = true;
            addChild(_startBtn);
        }
        private function _onTick(e:TimerEvent):void
        {
            _timeNum.num = LIMIT_TIME - Math.floor((getTimer() - _startTime) / 1000);
            if (_timeNum.num <= 0)
            {
                _gameOver();
                return;
            }
            _emitter.step();
            _char.move();
        }
    }
    
}
import com.bit101.components.*;
import flash.display.*;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.EventDispatcher;
import flash.geom.*;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;
import flash.utils.escapeMultiByte;
class GameOverScreen extends Window
{
    private var _score:int;
    private var _closeFunc:Function;
    public function GameOverScreen(score:int, parent:DisplayObjectContainer, x_:Number, y_:Number, closeHandler:Function)
    {
        _score = score;
        _closeFunc = closeHandler;
        super(parent, x_, y_,"result");
        _init();
    }
    private function _init():void
    {
        width  = 200;
        height = 80;
        new PushButton(this,  45, 50, "tweet!", _onClick).width = 50;
        new PushButton(this, 105, 50, "close" , _onCloseClick).width = 50;
        new Label(this, 50, 30, "score : "+_score.toString());
    }
    private function _onClick(e:MouseEvent):void
    {
        navigateToURL(new URLRequest("http://twitter.com/home?status=+" + escapeMultiByte("きのこを" +_score + "個採ったよ！！") + "+http://wonderfl.net/c/v0HW/+%23mariji"));
    }
    private function _onCloseClick(e:MouseEvent):void
    {
        var dx:Number = x + width  * .5,
            dy:Number = y + height * .5;
        BetweenAS3.serial(
            BetweenAS3.tween(this, { x:dx, y:dy, scaleX:0, scaleY:0 }, null, .8, Back.easeIn),
            BetweenAS3.removeFromParent(this),
            BetweenAS3.func(_closeFunc)
        ).play();
    }
}
class ImageParser
{
    public static const POS:Point = new Point();
    public static const ALPHA_CTRA:ColorTransform = new ColorTransform(1, 1, 1, 0);
    public static function parseImage(bitmapData:BitmapData):Object
    {
        var i:int = 0, len:int = 0,
            r:Rectangle = new Rectangle(),
            nums_array  :Vector.<BitmapData> = new Vector.<BitmapData>(10, true),
            smallImages :Vector.<BitmapData> = new Vector.<BitmapData>( 4, true),
            largeImages :Vector.<BitmapData> = new Vector.<BitmapData>( 4, true),
            scoreBase   :BitmapData = new BitmapData( 29,  16, true,  0x0),
            kinoko      :BitmapData = new BitmapData( 32,  32, true,  0x0),
            kuribo      :BitmapData = new BitmapData( 32,  32, true,  0x0),
            smallChar   :BitmapData = new BitmapData( 30,  32, true,  0x0),
            largeChar   :BitmapData = new BitmapData( 32,  64, true,  0x0),
            deathImage  :BitmapData = new BitmapData( 28,  28, true,  0x0),
            nums        :BitmapData = new BitmapData( 14,  14, true,  0x0),
            bgbmd       :BitmapData = new BitmapData(465, 465, false, 0x0);
            
            
        r.x = 0; r.y = 128;
        r.width = bgbmd.width;
        r.height = bgbmd.height;
        bgbmd.copyPixels(bitmapData, r, POS);
        
        r.x = 64; r.y = 0;
        r.width  = r.height = 14;
        
        for ( i = 0, len = 10; i < len ; i ++)
        {
            r.x = 64 + i * r.width;
            nums.colorTransform(nums.rect, ALPHA_CTRA);
            nums.copyPixels(bitmapData, r, POS);
            nums_array[i] = nums.clone();
        }
        
        r.x = 0; r.y = 0;
        r.width = r.height = 32;
        kuribo.copyPixels(bitmapData, r, POS);
        r.x = 32;
        kinoko.copyPixels(bitmapData, r, POS);
        
        r.x = 64; r.y = 14;
        r.width = 29; r.height = 16;
        scoreBase.copyPixels(bitmapData, r, POS);
        
        r.x = 0; r.y = 32;
        r.width = 30; r.height = 32;
        i = 0; len = 4;
        for (i = 0; i < len; i++)
        {
            smallChar.colorTransform(smallChar.rect, ALPHA_CTRA);
            r.x = i * r.width;
            smallChar.copyPixels(bitmapData, r, POS);
            smallImages[i] = smallChar.clone();
        }
        
        r.x = 0; r.y = 64;
        r.width = 32; r.height = 64;
        for ( i = 0; i < len; i++)
        {
            largeChar.colorTransform(largeChar.rect, ALPHA_CTRA);
            r.x = i * r.width;
            largeChar.copyPixels(bitmapData, r, POS);
            largeImages[i] = largeChar.clone();
        }
        
        r.x = 120; r.y = 32;
        r.width = r.height = 28;
        deathImage.copyPixels(bitmapData, r, POS);
        
        return  { 
                    background  : bgbmd, 
                    numbers     : nums_array, 
                    kinoko      : kinoko, 
                    kuribo      : kuribo, 
                    scoreBase   : scoreBase ,
                    smallImages : smallImages,
                    largeImages : largeImages,
                    deathImage  : deathImage
                };
    }
}

class Charactor extends Sprite
{
    public static const MOVE_RATE:int = 5;
    private namespace large = "large";
    private namespace small = "small";
    small static var _images:Vector.<BitmapData>;
    large static var _images:Vector.<BitmapData>;
    private static var _deathImage:BitmapData;
    public static function initImages(smallImages:Vector.<BitmapData>, largeImages:Vector.<BitmapData>,deathImage:BitmapData):void
    {
        small::_images = smallImages;
        large::_images = largeImages;
        _deathImage = deathImage;
    }
    private var _dir:int;
    
    small var _charImg:Bitmap;
    large var _charImg:Bitmap;
    private var _isBig:Boolean;
    private var _pos:int;
    private var _flg:Boolean;
    private var currentNS:Namespace;
    public function Charactor()
    {
        _init();
    }
    private function _init():void
    {
        _dir = 0;
        _flg = _isBig = false;
        
        addChildAt(small::_charImg = new Bitmap(small::_images[0]), 0);
        addChildAt(large::_charImg = new Bitmap(large::_images[0]), 0);
        large::_charImg.visible = false;
        
        large::_charImg.x = -Math.floor(large::_charImg.width * .5);
        large::_charImg.y = -large::_charImg.height;
        
        small::_charImg.x = -Math.floor(small::_charImg.width * .5);
        small::_charImg.y = -small::_charImg.height;
    }
    private function _onMouse(e:MouseEvent):void
    {
        if (e.type == MouseEvent.MOUSE_DOWN) 
        {
            _dir = -1;
            scaleX = -scaleX;
        }
        else
        {
            _dir = 1;
            scaleX = Math.abs(scaleX);
        }
    }
    public function move():void
    {
        x += _dir * MOVE_RATE;
        _flg = !_flg;
        if (_flg)
        {
            _pos = (++_pos > 3) ? 1 :_pos;
            currentNS::_charImg.bitmapData = currentNS::_images[_pos];
        }
        if (x < 0) x = 0;
        else if (x > 465) x = 465;
    }
    public function startMove():void
    {
        _dir = 1;
        x = 230;
        y = 398;
        currentNS = small;
        large::_charImg.visible = false;
        small::_charImg.visible = true;
        small::_charImg.bitmapData = small::_images[0];
        large::_charImg.bitmapData = large::_images[0];
        scaleX = scaleY = 1;
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN, _onMouse);
        stage.addEventListener(MouseEvent.MOUSE_UP, _onMouse);
    }
    public function death(completeFunc:Function):void
    {
        stage.removeEventListener(MouseEvent.MOUSE_DOWN, _onMouse);
        stage.removeEventListener(MouseEvent.MOUSE_UP  , _onMouse);
        _dir = 0;
        currentNS::_charImg.visible = false;
        
        var d:Bitmap = new Bitmap(_deathImage.clone()),
            tween:ITween = BetweenAS3.serial(
                                                BetweenAS3.addChild(d, this),
                                                BetweenAS3.func(
                                                                    function():void
                                                                    {
                                                                        d.x = -d.width * .5;
                                                                        d.y = -d.height;
                                                                        scaleX = scaleY = 1;
                                                                    }
                                                                ),
                                                BetweenAS3.tween(this, { y: y - 100 }, null, .4, Exponential.easeOut),
                                                BetweenAS3.delay(BetweenAS3.tween(this, { y: 500   }, null, .7, Cubic.easeIn), .2),
                                                BetweenAS3.removeFromParent(d),
                                                BetweenAS3.func(
                                                                    function():void
                                                                    {
                                                                        d.bitmapData.dispose();
                                                                    }
                                                                )
                                            );
        
        tween.onComplete = function():void
        {
            completeFunc();
        }
        tween.play();
    }
    public function setScore(value:int):void
    {
        if (value == 1)
        {
            if (scaleY >= 1 && currentNS == small) 
            {
                currentNS::_charImg.visible = false;
                currentNS = large;
                currentNS::_charImg.visible = true;
            }
            else 
            {
                scaleX += .2 * _dir;
                scaleY += .2;
            }
        }
        else
        {
            if (scaleY < 1 && currentNS == large)
            {
                currentNS::_charImg.visible = false;
                currentNS = small;
                currentNS::_charImg.visible = true;
            }
            else
            {
                scaleX -= _dir * .5
                scaleY -= .5;
                if (scaleY < .2)
                {
                    scaleY = .2;
                    scaleX = _dir * .2;
                }
            }
        }
    }
    public function get hitTarget():DisplayObject { return currentNS::_charImg; }
}

[Event(name="itemHit", type="ItemHitEvent")]
class ItemEmitter extends EventDispatcher
{
    private var _maxItems:int;
    private var _emitPos:Point;
    private var _items:Vector.<Item>;
    private var _container:DisplayObjectContainer;
    private var _rate:Number = .75;
    private var _itemClock:Number = .1;
    private var _hitTarget:Charactor;
    public function ItemEmitter(emitterPosition:Point,container:DisplayObjectContainer,hitTarget:Charactor,maxItems:int = 50)
    {
        _hitTarget = hitTarget;
        _emitPos = emitterPosition;
        _container = container;
        _maxItems = maxItems;
        _items = new Vector.<Item>();
    }
    public function removeItems():void
    {
        for each(var i:Item in _items)
        {
            _container.removeChild(i);
            i.dispose();
        }
        _items = null;
        _items = new Vector.<Item>();
    }
    public function step():void
    {
        _emitItem();
        var i:int = 0,
            len:int = _items.length,
            item:Item;
            
        for ( i = 0 ; i < len ; i++)
        {
            item = _items[i];
            item.move();
            
            if (item.hitTestObject(_hitTarget.hitTarget))
            {
                len = _removeItem(i, item);
                dispatchEvent(new ItemHitEvent(ItemHitEvent.ITEM_HIT, item.scorePoint));
                continue;
            }
            
            if (item.x + item.width < 0 || item.x > 465 || item.y  > 465) len = _removeItem(i, item);
        }
    }
    private function _removeItem(index:int,target:Item):int
    {
        (_container.removeChild(target) as Item).dispose();
        _items.splice(index, 1);
        return _items.length;
    }
    private function _emitItem():void
    {
        if (Math.random() > _itemClock || _items.length > _maxItems) return;
        
        var i:Item;
        if (Math.random() > _rate) i = new Kriboo();
        else i = new Kinoko();
        
        _container.addChild(i);
        _items.push(i);
        i.x = _emitPos.x + (Math.random() - .5) * 200;
        i.y = _emitPos.y;
    }
}
class ItemHitEvent extends Event
{
    public static const ITEM_HIT:String = "itemHit";
    private var _score:int;
    public function ItemHitEvent(type:String,score:int, bubbles:Boolean = false, cancelable:Boolean = false)
    {
        _score = score;
        super(type, bubbles, cancelable);
    }
    public function get score():int { return _score; };
}
class Item extends Bitmap
{
    private var _scorePoint:int;
    private var _dirX:Number;
    private var _dirY:Number;
    public function get scorePoint():int { return _scorePoint; };
    public function Item(image:BitmapData,scorePoint:int):void
    {
        _scorePoint = scorePoint;
        _init();
        super(image);
        scaleX = scaleY = .8;
    }
    private function _init():void
    {
        _dirX = (Math.random() -.5) * 5;
        _dirY = Math.random() * 3 + 2;
    }
    internal function move():void
    {
        x += _dirX;
        y += _dirY;
    }
    internal function dispose():void
    {
        if (bitmapData) bitmapData.dispose();
        
    }
}
class Score extends Sprite
{
    private var _scorenum:DotNumber;
    public function Score(baseImage:BitmapData)
    {
        addChildAt(_scorenum = new DotNumber(3), 0);
        _scorenum.x = addChildAt(new Bitmap(baseImage), 0).width + 2
        _scorenum.y = 1;
    }
    public function set score(value:int):void
    {
        _scorenum.num = value;
    }
    public function get score():int { return _scorenum.num; };
}
class DotNumber extends Bitmap
{
    private static var _bitmap:Vector.<BitmapData>
    public static function setNumberBitmapData(data:Vector.<BitmapData>):void
    {
        _bitmap = data;
    }
    private var _length:int;
    private var _num:int;
    public function DotNumber(length:int = 3)
    {
        _length = length;
        super(new BitmapData(_length * _bitmap[0].width, _bitmap[0].height, true, 0x0));
        num = 0;
    }
    public function set num(value:int):void
    {
        _num = value;
        bitmapData.colorTransform(bitmapData.rect, ImageParser.ALPHA_CTRA);
        var str:String = _num.toString(),
            i:int = 0, len:int = 0;
        for ( i = _length - 1; i >= len; i--)
        {
            if (str.length -1 < i) _setBitmapData(0, (_length -1) - i);
            else _setBitmapData(parseInt(str.substr((str.length -1) - i,1)), (_length -1) - i);
        }
    }
    private function _setBitmapData(num:int,pos:int):void
    {
        var bmd:BitmapData = _bitmap[num],
            p:Point = new Point(pos * _bitmap[0].width),
            r:Rectangle = new Rectangle(0, 0, _bitmap[0].width, _bitmap[0].height);
        bitmapData.copyPixels(bmd, r, p);
    }
    public function get num():int { return _num; };
}
class Kriboo extends Item
{
    private static var _image:BitmapData;
    public static function initImage(bitmapData:BitmapData):void
    {
        _image = bitmapData;
    }
    public function Kriboo()
    {
        super(_image.clone(), 0);
    }
}
class Kinoko extends Item
{
    private static var _image:BitmapData;
    public static function initImage(bitmapData:BitmapData):void
    {
        _image = bitmapData;
    }
    public function Kinoko()
    {
        super(_image.clone(),1);
    }
}