/**
 * Copyright saruzaru ( http://wonderfl.net/user/saruzaru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nLjF
 */

package {
    import flash.utils.Timer;
    import flash.events.*;
    import flash.display.*;
    import flash.geom.*;
    import flash.filters.*;
    import com.greensock.*;
    import com.greensock.easing.*; 
    public class concentricCircles extends Sprite {  
        private var blur:BlurFilter;
        private var bmpd:BitmapData;
        private var matrix:Array;
        private var trans:ColorMatrixFilter = new ColorMatrixFilter(matrix);
        private var ct:ColorTransform = new ColorTransform(1,.9,1,.95,0,0,0,0);
        private var container:Sprite;
        private var containerBMP:Sprite;
        private var once:Boolean = true;
        private var circleArr:Array = new Array();
        private var circleCol:Array = ["0xFF0090","0xF50893","0xEC1196","0xE31A9A","0xDA239D","0xD12BA1","0xC834A4","0xBF3DA8","0xB646AB","0xAD4FAF","0xA457B2","0x9B60B6","0x9269B9","0x8872BC","0x7F7BC0","0x7683C3","0x6D8CC7","0x6495CA","0x5B9ECE","0x52A7D1","0x49AFD5","0x40B8D8","0x37C1DC","0x2ECADF","0x25D3E3"];
        private var onceBool:Boolean = true;
        private var stepper:Number = 0;
        private var checker:Number = 0;
        private var myTimer:Timer = new Timer(1000);
        private var tl:TimelineMax = new TimelineMax({repeat:-1,yoyo:true,paused:true});
        public function concentricCircles() 
        {
            init();
            stage.addEventListener(Event.ENTER_FRAME, renderBlur); 
        }
        private function init():void
        {
            blur = new BlurFilter(2,2,2);            
            bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000); 
            matrix = new Array();
            matrix = matrix.concat([1, 0, 0, 0, 0]);
            matrix = matrix.concat([0, 1, 0, 0, 0]);
            matrix = matrix.concat([0, 0, 1, 0, 0]);
            matrix = matrix.concat([0, 0, 0, 1, -50]);
            myTimer.addEventListener(TimerEvent.TIMER, addTween); 
            myTimer.start();
            container = new Sprite();
            containerBMP = new Sprite();            
            addChild(container);
            addChild(containerBMP);
            containerBMP.addChild(new Bitmap(bmpd));  
            container.scaleY = container.scaleX = 1; 
            container.x = container.y = 0;
            container.visible = false;
            renderCircles(23);           
        }
        private function renderBlur(event:Event):void
        {
            bmpd.draw(container, null, null, BlendMode.ADD); 
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blur);
            bmpd.colorTransform(bmpd.rect,ct);
        }
        private function renderCircles( count:int):void
        {
            for(var i:uint = 0; i <= count; i++){
                circleArr[i] = createCircle();
            }        
            function createCircle():Sprite{
                var circle:Sprite = new Sprite(); 
                container.addChild(circle);
                circle.graphics.lineStyle(4,uint(circleCol[i])); 
                circle.graphics.drawCircle( 0, 0, 7*i)
                circle.graphics.endFill();
                circle.x = 232; 
                circle.y = 232;
                circle.rotationY = 90;
                return circle;
            }
        }
        private function addTween(event:TimerEvent):void 
        {
            checker++;
            stepper++;
            if (stepper >= 3) {
                stepper = 0;
            };
            var randRot:Number = Math.random()*180;
            switch(stepper) {
                case 0:
                    tl.insertMultiple(TweenMax.allTo(circleArr,3,{rotationX:String(randRot),ease:Quart.easeInOut,delay:checker},0.05));
                    break;
                case 1:
                    tl.insertMultiple(TweenMax.allTo(circleArr,3,{rotationY:String(randRot),ease:Quart.easeInOut,delay:checker},0.05));
                    break;
                case 2:
                    tl.insertMultiple(TweenMax.allTo(circleArr,3,{rotationZ:String(randRot),ease:Quart.easeInOut,delay:checker},0.05)); 
                    break;
            }
            if (checker >= 123) { 
                myTimer.stop(); 
            }
            tl.timeScale = .5;
            tl.play();
        }
    }
}