/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nK9S
 */

package {
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var CANVAS_WIDTH:int;
        private var CANVAS_HEIGHT:int;
        private var CANVAS_COLOR:uint=0x000000;
        private var canvas_data:BitmapData;
        private var canvas:Bitmap;
        
        private const CIRCLE_NUMBER:int=20;
        private const CIRCLE_MAX_SIZE:int=100;
        private const CIRCLE_MIN_SIZE:int=20;
        private const CIRCLE_MAX_SPEED:int=13;
        private const CIRCLE_MIN_SPEED:int=6;
        private var circleProperty:Array=[];
        
        private const blend:String="invert";
        
        public function FlashTest() 
        {
            // write as3 code here..
            CANVAS_WIDTH=stage.stageWidth;
            CANVAS_HEIGHT=stage.stageHeight;
            createCanvas();
        }
        private function createCanvas():void
        {
            canvas_data=new BitmapData
            (
                CANVAS_WIDTH,
                CANVAS_HEIGHT,
                false,
                CANVAS_COLOR
            );
            canvas=new Bitmap(canvas_data);
            addChild(canvas);
            createCircle();
       }
       private function createCircle():void
       {
           for(var i:int=0;i<CIRCLE_NUMBER;++i)
           {
               var cObject:Object=
               {
                  x:Math.floor(Math.random()*CANVAS_WIDTH),
                  y:Math.floor(Math.random()*CANVAS_HEIGHT),
                  posX:Math.floor(Math.random()*CANVAS_WIDTH),
                  posY:Math.floor(Math.random()*CANVAS_HEIGHT),
                  size:Math.floor(Math.random()*(CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)+CIRCLE_MIN_SIZE),
                  speed:Math.floor(Math.random()*(CIRCLE_MAX_SPEED-CIRCLE_MIN_SPEED)+CIRCLE_MIN_SPEED)
               };
               circleProperty.push(cObject);
               var c:Circle=new Circle(cObject.x,cObject.y,cObject.size);
               canvas_data.lock();
               canvas_data.draw(c,null,null,blend);
               canvas_data.unlock();
           }
           addEventListener(Event.EXIT_FRAME,loop);
       }
       
       private function loop(e:Event):void
       {
           canvas_data.fillRect(canvas_data.rect,CANVAS_COLOR);
           for(var i:int=0;i<CIRCLE_NUMBER;++i)
           {
               var cObject:Object=circleProperty[i];
               cObject.x+=(cObject.posX-cObject.x)/cObject.speed;
               cObject.y+=(cObject.posY-cObject.y)/cObject.speed;
               if(Math.abs(cObject.posX-cObject.x)<0.1)
               {
                   if(Math.abs(cObject.posY-cObject.y)<0.1)
                   {
                       cObject.posX=Math.floor(Math.random()*CANVAS_WIDTH);
                       cObject.posY=Math.floor(Math.random()*CANVAS_HEIGHT);
                       cObject.speed=Math.floor(Math.random()*(CIRCLE_MAX_SPEED-CIRCLE_MIN_SPEED)+CIRCLE_MIN_SPEED);
                   }
               }
               var c:Circle=new Circle(cObject.x,cObject.y,cObject.size);
               canvas_data.lock();
               canvas_data.draw(c,null,null,blend);
               canvas_data.unlock();
           }
       }
    }
}
import flash.display.Shape;
import flash.display.Sprite;

class Circle extends Sprite
{
    private var X:int;
    private var Y:int;
    private var SIZE:int;
    private var c:Shape;
    public function Circle(x:int,y:int,size:int)
    {
        X=x;
        Y=y;
        SIZE=size;
        create();
    }
    private function create():void
    {
        c=new Shape();
        c.graphics.beginFill(0xffffff,1);
        c.graphics.drawCircle(X,Y,SIZE);
        c.graphics.endFill();
        this.addChild(c);
    }

}
