/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nJ5w
 */

// forked from tkinjo's JigLibFlash Test2
// forked from tkinjo's JigLibFlash Test
package  
{
	/**
	 */
	
	import flash.display.Sprite;
	import flash.events.Event;
	import jiglib.geometry.JSphere;
	import jiglib.math.JNumber3D;
	import jiglib.physics.constraint.JConstraintPoint;
	import jiglib.physics.RigidBody;
	import jiglib.plugin.papervision3d.Papervision3DPhysics;
	import org.papervision3d.core.proto.CameraObject3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.AbstractView;
	import org.papervision3d.view.BasicView;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		private const speed:Number = 10;
		
		private var view:AbstractView;
		private var scene:Scene3D;
		private var camera:CameraObject3D;
		private var cameraTarget:DisplayObject3D;
		
		private var physics:Papervision3DPhysics;
		
		/**
		* 
		*/
		public function Main() 
		{
			view = new BasicView( stage.stageWidth, stage.stageHeight );
			addChild( view );
			
			scene = view.scene;
			camera = view.camera;
			
			
			
			/** --------------------------------------------------
			 * カメラ設定
			 */
			camera.x = 1000
			camera.y = 1000;
			
			cameraTarget = new DisplayObject3D();
			camera.lookAt( cameraTarget );
			
			
			
			/** --------------------------------------------------
			 * jiglib 設定
			 */
			physics = new Papervision3DPhysics( scene, speed );
			
			
			// マテリアルの準備
			var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
			var materials:MaterialsList = new MaterialsList();
			materials.addMaterial( wireframeMaterial, "all" );
			
			// 地面の作成
			var ground:RigidBody = physics.createCube( materials, 100, 100, 0 );
			ground.movable = false;
			
			
			// 球の作成
			var sphere:RigidBody;
			var prevSphere:RigidBody;
			
			for( var i:Number = 0; i < 5; i++ ){
				
				// 球の作成と位置の設定
				sphere = physics.createSphere( wireframeMaterial, 100 );
				sphere.currentState.position = ( i == 0 ) ? new JNumber3D( -( sphere.boundingSphere * 2 * 2 ), sphere.boundingSphere * 4, 0 ) : 
																				JNumber3D.add( prevSphere.currentState.position, new JNumber3D( sphere.boundingSphere * 2, 0, 0 ) );
				
				// 連結
				if (i != 0) {
					
					var pos1:JNumber3D = JNumber3D.multiply( JNumber3D.UP, -prevSphere.boundingSphere );
					var pos2:JNumber3D = JNumber3D.multiply( JNumber3D.UP, sphere.boundingSphere );
					var constraint:JConstraintPoint = new JConstraintPoint( prevSphere, pos1, sphere, pos2, 0, 0 );
				}
				
				prevSphere = sphere;
			}
			
			/** --------------------------------------------------
			 * レンダリング
			 */
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
			view.startRendering();
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			physics.step();
		}
	}
}