/**
 * Copyright Fumio ( http://wonderfl.net/user/Fumio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nJ3p
 */

// forked from Fumio's forked from: radian角度をπ範囲に丸める
// forked from uwi's radian角度をπ範囲に丸める
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

// @see http://tail.s288.xrea.com/open/index.php?%A5%E1%A5%E2%BD%F1%A4%AD%2Fradian%B3%D1%C5%D9%A4%F2%A6%D0%C8%CF%B0%CF%A4%CB%B4%DD%A4%E1%A4%EB
public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 10000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("からっぽ", function ():void
        {
            var begin:int = -_NUM_TIMES / 2;
            var end:int = _NUM_TIMES + begin;
            for (var i:int = begin; i < end; i++) {
                var angle : Number = i;
                var res : Number = 3.14;
            }
        });
        
        _measure("chibitami", function ():void
        {
            var begin:int = -_NUM_TIMES / 2;
            var end:int = _NUM_TIMES + begin;
            for (var i:int = begin; i < end; i++) {
                var rad : Number = i;
                var res : Number = adjustRadianC(rad);
            }
        });
        
        _measure("fumio", function ():void
        {
            var begin:int = -_NUM_TIMES / 2;
            var end:int = _NUM_TIMES + begin;
            for (var i:int = begin; i < end; i++) {
                var angle : Number = i;
                var res : Number = adjustRadianF(angle);
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private function adjustRadianC(rad:Number):Number {
        var res : Number = rad - 2.0 * Math.PI * Math.floor( 0.5 + rad / ( 2.0 * Math.PI ) ) ;
        return res;
    }
    
    private function adjustRadianF(nAngle:Number):Number {
        var nHalf:Number = Math.PI;
        nAngle +=  nHalf;
        nAngle %=  nHalf * 2;
        nAngle = (nAngle < 0) ? nAngle + nHalf : nAngle - nHalf;
        // var nFull:Number = nHalf * 2;
        // nAngle %=  nHalf * 2;
        /*
        var nFull:Number = nHalf * 2;
        nAngle -=  nFull * Math.floor(nAngle / nFull);
        nAngle -= nHalf;
        */
        return nAngle;
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
