/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nIlI
 */

// forked from tenasaku's flash on 2010-3-20

// fork 元の趣旨から外れてしまいましたが・・・
// クリックでブラーかけたりかけなかったり

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    
    public class FlashTest extends Sprite
    {
        private var wz:int;
        private var hi:int;
        private var cnt:int;
        
        private var fromX:Number;
        private var fromY:Number;
        private var fromXv:Number;
        private var fromYv:Number;
        
        private var toX:Number;
        private var toY:Number;
        private var toXv:Number;
        private var toYv:Number;
        
        private var disp:Bitmap;
        private var line:Shape;
        private var canv:Bitmap;
        private var blur:Array;
        private var ct:ColorTransform;
        
        private var dd:Function;
        private var lc:Function;
        private var ls:Function;
        private var lm:Function;
        private var ll:Function;
        private var cd:Function;
        
        
        public function FlashTest()
        {
            wz  = stage.stageWidth;
            hi  = stage.stageHeight;
            cnt = 0;
            
            fromX  = 0;
            fromY  = 0;
            fromXv = 5 + Math.random() * 5;
            fromYv = 5 + Math.random() * 5;
            
            toX  = wz;
            toY  = hi;
            toXv = 5 + Math.random() * 5;
            toYv = 5 + Math.random() * 5;
            
            disp = new Bitmap( new BitmapData(wz, hi, false, 0) );
            line = new Shape();
            canv = new Bitmap(disp.bitmapData.clone());
            blur = [ new BlurFilter(8, 8) ];
            ct   = new ColorTransform(0.9, 0.9, 0.9);
            
            dd = disp.bitmapData.draw;
            lc = line.graphics.clear;
            ls = line.graphics.lineStyle;
            lm = line.graphics.moveTo;
            ll = line.graphics.lineTo;
            cd = canv.bitmapData.draw;
            
            addChild(disp);
            
            stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
            {
                canv.filters = canv.filters.length == 0 ? blur : null;
            });
        }
        
        
        private function atEveryFrame(e:Event):void
        {
            cd(disp, null, ct);
            
            lc();
            ls(6, hue2rgb(cnt));
            lm(fromX, fromY);
            ll(toX, toY);
            
            cd(line);
            
            dd(canv);
            
            cnt = (cnt + 5) % 360;
            
            fromX += fromXv;
            if (fromX < 0 || fromX > wz) fromX += fromXv *= -1;
            fromY += fromYv;
            if (fromY < 0 || fromY > hi) fromY += fromYv *= -1;
            
            toX += toXv;
            if (toX < 0 || toX > wz) toX += toXv *= -1;
            toY += toYv;
            if (toY < 0 || toY > hi) toY += toYv *= -1;
        }
        
        
        private function hue2rgb(h:Number):uint
        {
            var i:int    = int(h / 60);
            var f:Number = 0xFF * (h / 60 - i);
            
            switch (i) {
                case 0: return       0xFF0000 |        f << 8 |             0;
                case 1: return 0xFF - f << 16 |        0xFF00 |             0;
                case 2: return              0 |        0xFF00 |        f << 0;
                case 3: return              0 | 0xFF - f << 8 |          0xFF;
                case 4: return        f << 16 |             0 |          0xFF;
                case 5: return       0xFF0000 |             0 | 0xFF - f << 0;
            }
            
            return 0;
        }
    }
}
