/**
 * Copyright bunta ( http://wonderfl.net/user/bunta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nI61
 */

// forked from siaukia's forked from: Chopping 3D Objects
// forked from siaukia's Chopping 3D Objects
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
        
    import gs.TweenMax;
    import gs.easing.*;

    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.MeshUtil;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.core.proto.CameraObject3D;    
    
    public class Chopping3D extends Sprite {
        
        private var view:BasicView;
        private var materialsList:MaterialsList;
        private var cubeMaterial:BitmapMaterial;
        private var cubeHolder:DisplayObject3D;
        private var cube:Cube

        private var bmp:BitmapData
        
        public function Chopping3D() {
            setupScene();
        }
        
        private function setupScene():void {
	    view 					= new BasicView(100, 100, true, true, CameraType.FREE);
	    var scene:Scene3D 				= view.scene;
	    var camera:CameraObject3D 			= view.camera;
	
	    bmp 					= new BitmapData(512,255,false,0);
	    bmp.perlinNoise(64,64,4,123456,true,false,7,true);
            cubeMaterial 		        	= new BitmapMaterial(bmp);
	    cubeMaterial.doubleSided			= true;
            materialsList                               = new MaterialsList({all:cubeMaterial})
            cube	                    	        = new Cube(materialsList, 400, 400, 400, 15, 15);
            cubeHolder		        		= new DisplayObject3D;
		
	    var arrayExploded:Array 			= explodeObject(cube);
	
	    for (var i:int = 0; i < arrayExploded.length; i++) {
		var positionX:Number			= ((Math.random()*1000)-1000)+500
		var positionY:Number			= ((Math.random()*1000)-1000)+500
		var positionZ:Number			= ((Math.random()*1000)-1000)+500
		var rotationX:Number			= Math.random()*360
		var rotationY:Number			= Math.random()*360
		var rotationZ:Number			= Math.random()*360		

		cubeHolder.addChild(arrayExploded[i]);
		TweenMax.from(arrayExploded[i], 2, {delay:i/8, x:positionX, y:positionY, z:positionZ, scaleX:0, scaleY:0,             rotationX:rotationX, rotationY:rotationY, rotationZ:rotationZ, ease:Expo.easeInOut})
	}

	        scene.addChild(cubeHolder)
        	this.addChild(view);	
        	this.addEventListener(Event.ENTER_FRAME, stageEnterFrame);
        }

        private function stageEnterFrame(e:Event):void {
        	cubeHolder.yaw(1)
        	cubeHolder.pitch(1)	
        	view.singleRender();
        }

// ----------------------------------------------------------------------------------------------------

        private function explodeObject(object:TriangleMesh3D):Array {
        	var a:Array 				= chopMesh(object, "x");

        	var b:Array				= chopMesh(a[0], "y");
                var c:Array				= chopMesh(a[1], "y");
	
	        var d:Array				= chopMesh(b[0], "z");
                var e:Array				= chopMesh(b[1], "z");	
	        var f:Array			        = chopMesh(c[0], "z");
                var g:Array				= chopMesh(c[1], "z");	
		
	        var arrayObjects:Array			= new Array();
	        arrayObjects	                        = d.concat(e).concat(f).concat(g);

        	return arrayObjects;
        }

        private function chopMesh(object:TriangleMesh3D, direction:String):Array {
	        var choppedMesh:Array 			= new Array();
	        var plane3D:Plane3D 			= new Plane3D();
	        var point:Number3D		        = new Number3D(0,0,0);
	
	        if (direction 				== "x") {
	            plane3D 				= Plane3D.fromNormalAndPoint(new Number3D(0, 1, 0), point);	
	        } else if (direction 			== "y") {
		    plane3D 			        = Plane3D.fromNormalAndPoint(new Number3D(1, 0, 0), point);	
	        } else if (direction 			== "z") {
		    plane3D 				= Plane3D.fromNormalAndPoint(new Number3D(0, 0, 1), point);	
	        }
	
	        choppedMesh				= MeshUtil.cutTriangleMesh(object, plane3D);
	        choppedMesh[0]				= TriangleMesh3D(choppedMesh[0])
	        choppedMesh[1]				= TriangleMesh3D(choppedMesh[1])	

	        return choppedMesh;
        }   
    }
}