/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nHxW
 */

// forked from toyoshim's PV3D 練習その２
// forked from toyoshim's PV3D 練習その１
/*
 * いろいろなプリミティブを追加してみた。
 * Cubeはmaterialがうまく指定できずに断念。。。
 * 09/08/17追記: 自己解決
 */
package {
    import flash.display.*;
    import flash.events.*;
 
    import org.papervision3d.objects.*;
    import org.papervision3d.typography.*;
    import org.papervision3d.typography.fonts.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.core.effects.view.*;
    
    import net.hires.debug.Stats;
 
    [SWF(backgroundColor=0x000008)]
 
    public class MyPlane extends ReflectionView
    {
        private var rootNode    : DisplayObject3D;
        private var planeObj    : DisplayObject3D;
        private var arrowObj    : DisplayObject3D;
        private var coneObj     : DisplayObject3D;
        private var cubeObj     : DisplayObject3D;
        private var cylinderObj : DisplayObject3D;
        private var pppObj      : DisplayObject3D;
        private var sphereObj   : DisplayObject3D;
        private var letterObj   : DisplayObject3D;
        private var letter      : Letter3DMaterial;
        private var material    : ColorMaterial;
 
        public function MyPlane():void
        {
            // フレームレート設定
            stage.frameRate = 60;
            
            // 反射する床
            surfaceHeight = -300;
            viewportReflection.alpha = .1;
 
            // rootNode生成
            rootNode = new DisplayObject3D();
            scene.addChild( rootNode );
 
            // マテリアル設定
            material = new ColorMaterial( 0xffaacc, 0.3 );
            material.oneSide = false;
 
            // Planeオブジェクト生成
            planeObj = new Plane( material, 300, 300, 1, 1);
            planeObj.y = 500;
            planeObj.z = 300;
            rootNode.addChild( planeObj );
            
            // Arrowオブジェクト生成
            arrowObj = new Arrow();
            arrowObj.x = 450;
            arrowObj.y = 400;
            arrowObj.z = 400;
            rootNode.addChild( arrowObj );
            
            // Coneオブジェクト生成
            coneObj = new Cone();
            coneObj.x = 400;
            rootNode.addChild( coneObj );
            
            // Cubeオブジェクト
            cubeObj = new Cube(new MaterialsList( { all: material } ));
            cubeObj.z = 4000;
            cubeObj.y = 3000;
            cubeObj.x = 3000;
            rootNode.addChild( cubeObj );

            // Cylinderオブジェクト生成
            cylinderObj = new Cylinder();
            cylinderObj.x = -400;
            cylinderObj.y = 400;
            rootNode.addChild( cylinderObj );

            // PaperPlaneオブジェクト生成
            pppObj = new PaperPlane( material );
            pppObj.x = -400;
            pppObj.z = -300;
            rootNode.addChild( pppObj );
            
            // Sphereオブジェクト生成
            sphereObj = new Sphere();
            rootNode.addChild( sphereObj );
            
            // 文字オブジェクト生成
            letter = new Letter3DMaterial(0x4422cc, 0.7);
            letter.oneSide = false;
            letterObj = new Text3D("A", new HelveticaBold(), letter);
            letterObj.z = -300;
            letterObj.x = -200;
            rootNode.addChild( letterObj );

            // カメラ設定
            camera.z = -1000;
            camera.focus = 30;
            camera.zoom = 10;

            // デバッグ情報
            stage.addChild(new Stats()); 
            
            // イベント登録
            stage.addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop( event:Event ):void
        {
            // 回転
            planeObj.rotationX += 2;
            planeObj.rotationY += 5;
            planeObj.rotationZ += 1;
            
            arrowObj.rotationX += 3;
            sphereObj.rotationY -= 1;
            cylinderObj.rotationZ += 1;
            coneObj.rotationY += 3;
            cubeObj.rotationX += 1;
            cubeObj.rotationY += 2;
            cubeObj.rotationZ += 3;
            pppObj.rotationX += 1;
            pppObj.rotationY += 2;
            pppObj.rotationZ += 3;
            letterObj.rotationY += 1;
 
            // 再レンダリング
            singleRender();
        }
    }
}
