/**
 * Copyright amane ( http://wonderfl.net/user/amane )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nHk0
 */

package  
{
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(backgroundColor = "0x000000", frameRate = "100")]
	public class Maintest extends Sprite 
	{
		//メンバ変数
		private var m_aBall:Array;				//Ballオブジェクト格納用配列
		private var m_aVelocityX:Array;			//Ballの速度X
		private var m_aVelocityY:Array;			//Ballの速度Y
		private var m_uiColor24:uint;			//色(24bit)
		private var m_iCount:int = 100;			//カウント
		private var m_nGravity:Number = 1;			//引力
		private var m_nFriction:Number = 0.9;		//摩擦
		private var m_nEasing:Number = 0.01;			//easing
		private var m_iRed:int = 255;			//色:赤
		private var m_iGreen:int = 0;			//色:緑
		private var m_iBlue:int = 0;			//色:青
		private var m_oSprite:Sprite;
		private var m_nSpring:Number = 0.3;			//バネ
		
		//コンストラクタ
		public function Maintest() 
		{
			init();
		}
		
		public function init():void{
			//ウィンドウサイズに合わせる
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			//4.Chain Spring
			m_aBall = new Array();
			m_aVelocityX = new Array();
			m_aVelocityY = new Array();
			for (var i:int = 0; i < m_iCount; i++) {
				//base
				m_oSprite = new Sprite();
				//ball
				var spBall:Sprite = new Sprite();
				var uiColor:uint = Math.random() * 0xfffffff;
				var nSize:Number = Math.random() * 10;
				var nVelocityX:Number = 0;
				var nVelocityY:Number = 0;
				spBall.graphics.beginFill(uiColor);
				spBall.graphics.drawCircle(0,0,nSize);
				spBall.graphics.endFill();
				m_oSprite.addChild(spBall);
				addChild(m_oSprite);
				m_aBall.push(spBall);
				m_aVelocityX.push(nVelocityX);
				m_aVelocityY.push(nVelocityY);
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		public function onEnterFrame(event:Event):void {
			//4.Chain Spring
			//最初の一つ
			moveBall(m_aBall[0],m_aVelocityX[0],m_aVelocityY[0], mouseX, mouseY);
			//line color
			m_uiColor24 = m_iRed << 16 | m_iGreen << 8 | m_iBlue;
			m_oSprite.graphics.clear();
			m_oSprite.graphics.lineStyle(1,m_uiColor24);
			m_oSprite.graphics.moveTo(mouseX,  mouseY);
			m_oSprite.graphics.lineTo(m_aBall[0].x, m_aBall[0].y);
			for (var i:int = 1; i < m_iCount; i++) {
				moveBall(m_aBall[i],m_aVelocityX[i-1],m_aVelocityY[i-1], m_aBall[i-1].x, m_aBall[i-1].y);
				m_oSprite.graphics.lineTo(m_aBall[i].x, m_aBall[i].y);
			}
		}
		private function moveBall(ball:Sprite,vx:Number,vy:Number, tx:Number, ty:Number):void {
			//バネ
			vx += (tx - ball.x) * m_nSpring;
			vy += (ty - ball.y) * m_nSpring;
			//引力
			vy += m_nGravity;
			//摩擦
			vx *= m_nFriction;
			vy *= m_nFriction;
			//移動
			ball.x += vx;
			ball.y += vy;
		}
	}
	internal class Ball extends Sprite
	{
		//プロパティ
		public var vx:Number = 0;				//速度X
		public var vy:Number = 0;				//速度Y	
		public var radius:Number;				//半径
		public var color:uint;				//32 ビットの符号なし整数（intの 2 倍）
		
		//コンストラクタ
		public function Ball(nRadius:Number=40,uiColor:uint=0xff0000) 
		{
			this.radius = nRadius;
			this.color = uiColor;
			init();
		}
		
		public function init():void{
			graphics.beginFill(color);
			graphics.drawCircle(0,0,radius);
			graphics.endFill();
		}
	}
}